/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.Duration;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.co.KeyedCoProcessFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamFlatMap;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.api.operators.co.KeyedCoProcessOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.api.transformations.UnionTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.IntervalJoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.KeyedCoProcessOperatorWithWatermarkDelay;
import org.apache.flink.table.runtime.operators.join.OuterJoinPaddingUtil;
import org.apache.flink.table.runtime.operators.join.interval.FilterAllFlatMapFunction;
import org.apache.flink.table.runtime.operators.join.interval.IntervalJoinFunction;
import org.apache.flink.table.runtime.operators.join.interval.PaddingLeftMapFunction;
import org.apache.flink.table.runtime.operators.join.interval.PaddingRightMapFunction;
import org.apache.flink.table.runtime.operators.join.interval.ProcTimeIntervalJoin;
import org.apache.flink.table.runtime.operators.join.interval.RowTimeIntervalJoin;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExecNodeMetadata(name="stream-exec-interval-join", version=1, producedTransformations={"filter-left", "filter-right", "pad-left", "pad-right", "interval-join"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecIntervalJoin
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
MultipleTransformationTranslator<RowData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamExecIntervalJoin.class);
    public static final String FILTER_LEFT_TRANSFORMATION = "filter-left";
    public static final String FILTER_RIGHT_TRANSFORMATION = "filter-right";
    public static final String PAD_LEFT_TRANSFORMATION = "pad-left";
    public static final String PAD_RIGHT_TRANSFORMATION = "pad-right";
    public static final String INTERVAL_JOIN_TRANSFORMATION = "interval-join";
    public static final String FIELD_NAME_INTERVAL_JOIN_SPEC = "intervalJoinSpec";
    @JsonProperty(value="intervalJoinSpec")
    private final IntervalJoinSpec intervalJoinSpec;

    public StreamExecIntervalJoin(ReadableConfig tableConfig, IntervalJoinSpec intervalJoinSpec, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecIntervalJoin.class), ExecNodeContext.newPersistedConfig(StreamExecIntervalJoin.class, tableConfig), intervalJoinSpec, Lists.newArrayList((Object[])new InputProperty[]{leftInputProperty, rightInputProperty}), outputType, description);
    }

    @JsonCreator
    public StreamExecIntervalJoin(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="intervalJoinSpec") IntervalJoinSpec intervalJoinSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 2 ? 1 : 0) != 0);
        this.intervalJoinSpec = (IntervalJoinSpec)Preconditions.checkNotNull((Object)intervalJoinSpec);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        RowType leftRowType = (RowType)leftInputEdge.getOutputType();
        RowType rightRowType = (RowType)rightInputEdge.getOutputType();
        Transformation<?> leftInputTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightInputTransform = rightInputEdge.translateToPlan(planner);
        RowType returnType = (RowType)this.getOutputType();
        InternalTypeInfo returnTypeInfo = InternalTypeInfo.of((RowType)returnType);
        JoinSpec joinSpec = this.intervalJoinSpec.getJoinSpec();
        IntervalJoinSpec.WindowBounds windowBounds = this.intervalJoinSpec.getWindowBounds();
        long minCleanUpIntervalMillis = ((Duration)planner.getTableConfig().get(ExecutionConfigOptions.TABLE_EXEC_INTERVAL_JOIN_MIN_CLEAN_UP_INTERVAL)).toMillis();
        switch (joinSpec.getJoinType()) {
            case INNER: 
            case LEFT: 
            case RIGHT: 
            case FULL: {
                long relativeWindowSize = windowBounds.getLeftUpperBound() - windowBounds.getLeftLowerBound();
                if (relativeWindowSize < 0L) {
                    LOGGER.warn("The relative time interval size " + relativeWindowSize + "is negative, please check the join conditions.");
                    return this.createNegativeWindowSizeJoin(joinSpec, leftInputTransform, rightInputTransform, leftRowType.getFieldCount(), rightRowType.getFieldCount(), (InternalTypeInfo<RowData>)returnTypeInfo, config);
                }
                GeneratedJoinCondition joinCondition = JoinUtil.generateConditionFunction((ReadableConfig)config, planner.getFlinkContext().getClassLoader(), joinSpec, (LogicalType)leftRowType, (LogicalType)rightRowType);
                IntervalJoinFunction joinFunction = new IntervalJoinFunction(joinCondition, returnTypeInfo, joinSpec.getFilterNulls());
                TwoInputTransformation<RowData, RowData, RowData> transform = windowBounds.isEventTime() ? this.createRowTimeJoin(leftInputTransform, rightInputTransform, (InternalTypeInfo<RowData>)returnTypeInfo, joinFunction, joinSpec, windowBounds, minCleanUpIntervalMillis, config) : this.createProcTimeJoin(leftInputTransform, rightInputTransform, (InternalTypeInfo<RowData>)returnTypeInfo, joinFunction, joinSpec, windowBounds, minCleanUpIntervalMillis, config);
                if (this.inputsContainSingleton()) {
                    transform.setParallelism(1);
                    transform.setMaxParallelism(1);
                }
                RowDataKeySelector leftSelect = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), joinSpec.getLeftKeys(), (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)leftRowType));
                RowDataKeySelector rightSelect = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), joinSpec.getRightKeys(), (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)rightRowType));
                transform.setStateKeySelectors((KeySelector)leftSelect, (KeySelector)rightSelect);
                transform.setStateKeyType((TypeInformation)leftSelect.getProducedType());
                return transform;
            }
        }
        throw new TableException("Interval Join: " + joinSpec.getJoinType() + " Join between stream and stream is not supported yet.\nplease re-check interval join statement according to description above.");
    }

    private Transformation<RowData> createNegativeWindowSizeJoin(JoinSpec joinSpec, Transformation<RowData> leftInputTransform, Transformation<RowData> rightInputTransform, int leftArity, int rightArity, InternalTypeInfo<RowData> returnTypeInfo, ExecNodeConfig config) {
        boolean shouldCreateUid = config.isCompiled();
        FilterAllFlatMapFunction allFilter = new FilterAllFlatMapFunction(returnTypeInfo);
        OuterJoinPaddingUtil paddingUtil = new OuterJoinPaddingUtil(leftArity, rightArity);
        PaddingLeftMapFunction leftPadder = new PaddingLeftMapFunction(paddingUtil, returnTypeInfo);
        PaddingRightMapFunction rightPadder = new PaddingRightMapFunction(paddingUtil, returnTypeInfo);
        int leftParallelism = leftInputTransform.getParallelism();
        int rightParallelism = rightInputTransform.getParallelism();
        OneInputTransformation filterAllLeftStream = new OneInputTransformation(leftInputTransform, "FilterLeft", (OneInputStreamOperator)new StreamFlatMap((FlatMapFunction)allFilter), returnTypeInfo, leftParallelism, false);
        if (shouldCreateUid) {
            filterAllLeftStream.setUid(this.createTransformationUid(FILTER_LEFT_TRANSFORMATION, config));
        }
        filterAllLeftStream.setDescription(this.createFormattedTransformationDescription("filter all left input transformation", config));
        filterAllLeftStream.setName(this.createFormattedTransformationName(filterAllLeftStream.getDescription(), "FilterLeft", config));
        OneInputTransformation filterAllRightStream = new OneInputTransformation(rightInputTransform, "FilterRight", (OneInputStreamOperator)new StreamFlatMap((FlatMapFunction)allFilter), returnTypeInfo, rightParallelism, false);
        if (shouldCreateUid) {
            filterAllRightStream.setUid(this.createTransformationUid(FILTER_RIGHT_TRANSFORMATION, config));
        }
        filterAllRightStream.setDescription(this.createFormattedTransformationDescription("filter all right input transformation", config));
        filterAllRightStream.setName(this.createFormattedTransformationName(filterAllRightStream.getDescription(), "FilterRight", config));
        OneInputTransformation padLeftStream = new OneInputTransformation(leftInputTransform, "PadLeft", (OneInputStreamOperator)new StreamMap((MapFunction)leftPadder), returnTypeInfo, leftParallelism, false);
        if (shouldCreateUid) {
            padLeftStream.setUid(this.createTransformationUid(PAD_LEFT_TRANSFORMATION, config));
        }
        padLeftStream.setDescription(this.createFormattedTransformationDescription("pad left input transformation", config));
        padLeftStream.setName(this.createFormattedTransformationName(padLeftStream.getDescription(), "PadLeft", config));
        OneInputTransformation padRightStream = new OneInputTransformation(rightInputTransform, "PadRight", (OneInputStreamOperator)new StreamMap((MapFunction)rightPadder), returnTypeInfo, rightParallelism, false);
        if (shouldCreateUid) {
            padRightStream.setUid(this.createTransformationUid(PAD_RIGHT_TRANSFORMATION, config));
        }
        padRightStream.setDescription(this.createFormattedTransformationDescription("pad right input transformation", config));
        padRightStream.setName(this.createFormattedTransformationName(padRightStream.getDescription(), "PadRight", config));
        switch (joinSpec.getJoinType()) {
            case INNER: {
                return new UnionTransformation((List)Lists.newArrayList((Object[])new Transformation[]{filterAllLeftStream, filterAllRightStream}));
            }
            case LEFT: {
                return new UnionTransformation((List)Lists.newArrayList((Object[])new Transformation[]{padLeftStream, filterAllRightStream}));
            }
            case RIGHT: {
                return new UnionTransformation((List)Lists.newArrayList((Object[])new Transformation[]{filterAllLeftStream, padRightStream}));
            }
            case FULL: {
                return new UnionTransformation((List)Lists.newArrayList((Object[])new Transformation[]{padLeftStream, padRightStream}));
            }
        }
        throw new TableException("should no reach here");
    }

    private TwoInputTransformation<RowData, RowData, RowData> createProcTimeJoin(Transformation<RowData> leftInputTransform, Transformation<RowData> rightInputTransform, InternalTypeInfo<RowData> returnTypeInfo, IntervalJoinFunction joinFunction, JoinSpec joinSpec, IntervalJoinSpec.WindowBounds windowBounds, long minCleanUpIntervalMillis, ExecNodeConfig config) {
        InternalTypeInfo leftTypeInfo = (InternalTypeInfo)leftInputTransform.getOutputType();
        InternalTypeInfo rightTypeInfo = (InternalTypeInfo)rightInputTransform.getOutputType();
        ProcTimeIntervalJoin procJoinFunc = new ProcTimeIntervalJoin(joinSpec.getJoinType(), windowBounds.getLeftLowerBound(), windowBounds.getLeftUpperBound(), minCleanUpIntervalMillis, leftTypeInfo, rightTypeInfo, joinFunction);
        return ExecNodeUtil.createTwoInputTransformation(leftInputTransform, rightInputTransform, this.createTransformationMeta(INTERVAL_JOIN_TRANSFORMATION, config), new KeyedCoProcessOperator((KeyedCoProcessFunction)procJoinFunc), returnTypeInfo, leftInputTransform.getParallelism(), false);
    }

    private TwoInputTransformation<RowData, RowData, RowData> createRowTimeJoin(Transformation<RowData> leftInputTransform, Transformation<RowData> rightInputTransform, InternalTypeInfo<RowData> returnTypeInfo, IntervalJoinFunction joinFunction, JoinSpec joinSpec, IntervalJoinSpec.WindowBounds windowBounds, long minCleanUpIntervalMillis, ExecNodeConfig config) {
        InternalTypeInfo leftTypeInfo = (InternalTypeInfo)leftInputTransform.getOutputType();
        InternalTypeInfo rightTypeInfo = (InternalTypeInfo)rightInputTransform.getOutputType();
        RowTimeIntervalJoin rowJoinFunc = new RowTimeIntervalJoin(joinSpec.getJoinType(), windowBounds.getLeftLowerBound(), windowBounds.getLeftUpperBound(), 0L, minCleanUpIntervalMillis, leftTypeInfo, rightTypeInfo, joinFunction, windowBounds.getLeftTimeIdx(), windowBounds.getRightTimeIdx());
        return ExecNodeUtil.createTwoInputTransformation(leftInputTransform, rightInputTransform, this.createTransformationMeta(INTERVAL_JOIN_TRANSFORMATION, config), new KeyedCoProcessOperatorWithWatermarkDelay((KeyedCoProcessFunction)rowJoinFunc, rowJoinFunc.getMaxOutputDelay()), returnTypeInfo, leftInputTransform.getParallelism(), false);
    }
}

