/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.sql.parser.ddl.SqlCreateModel;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.CreateModelOperation;
import org.apache.flink.table.planner.operations.SchemaBuilderUtil;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SqlCreateModelConverter
implements SqlNodeConverter<SqlCreateModel> {
    @Override
    public Operation convertSqlNode(SqlCreateModel sqlCreateModel, SqlNodeConverter.ConvertContext context) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateModel.fullModelName());
        ObjectIdentifier identifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        Map<String, String> modelOptions = this.getModelOptions(sqlCreateModel);
        ModelSchemaBuilderUtils schemaBuilderUtil = new ModelSchemaBuilderUtils(context.getSqlValidator(), SqlNode::toString, context.getCatalogManager().getDataTypeFactory());
        CatalogModel catalogModel = CatalogModel.of((Schema)schemaBuilderUtil.getSchema(sqlCreateModel.getInputColumnList(), true), (Schema)schemaBuilderUtil.getSchema(sqlCreateModel.getOutputColumnList(), false), modelOptions, (String)sqlCreateModel.getComment().map(SqlLiteral::toValue).orElse(null));
        return new CreateModelOperation(identifier, context.getCatalogManager().resolveCatalogModel(catalogModel), sqlCreateModel.isIfNotExists(), sqlCreateModel.isTemporary());
    }

    private Map<String, String> getModelOptions(SqlCreateModel sqlCreateModel) {
        HashMap<String, String> options = new HashMap<String, String>();
        sqlCreateModel.getPropertyList().getList().forEach(p -> options.put(((SqlTableOption)Objects.requireNonNull(p)).getKeyString(), ((SqlTableOption)p).getValueString()));
        return options;
    }

    private static class ModelSchemaBuilderUtils
    extends SchemaBuilderUtil {
        ModelSchemaBuilderUtils(SqlValidator sqlValidator, Function<SqlNode, String> escapeExpressions, DataTypeFactory dataTypeFactory) {
            super(sqlValidator, escapeExpressions, dataTypeFactory);
        }

        private Schema getSchema(SqlNodeList nodeList, boolean isInput) {
            this.columns.clear();
            String schemaType = isInput ? "input" : "output";
            for (SqlNode column : nodeList) {
                if (column instanceof SqlTableColumn.SqlRegularColumn) {
                    SqlTableColumn.SqlRegularColumn regularColumn = (SqlTableColumn.SqlRegularColumn)column;
                    String name = regularColumn.getName().getSimple();
                    if (this.columns.containsKey(name)) {
                        throw new ValidationException("Duplicate " + schemaType + " column name: '" + name + "'.");
                    }
                    this.columns.put(name, this.toUnresolvedPhysicalColumn(regularColumn));
                    continue;
                }
                throw new ValidationException("Column " + column + " can only be a physical column.");
            }
            return this.build();
        }
    }
}

