/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.commons.text.StringSubstitutor;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.calc.async.DelegatingAsyncResultFuture;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

public class AsyncCodeGenerator {
    public static final String DEFAULT_EXCEPTION_TERM = "e";
    public static final String DEFAULT_DELEGATING_FUTURE_TERM = "f";

    public static GeneratedFunction<AsyncFunction<RowData, RowData>> generateFunction(String name, RowType inputType, RowType returnType, List<RexNode> calcProjection, boolean retainHeader, ReadableConfig tableConfig, ClassLoader classLoader) {
        CodeGeneratorContext ctx = new CodeGeneratorContext(tableConfig, classLoader);
        String processCode = AsyncCodeGenerator.generateProcessCode(ctx, inputType, returnType, calcProjection, retainHeader, CodeGenUtils.DEFAULT_INPUT1_TERM(), CodeGenUtils.DEFAULT_COLLECTOR_TERM(), DEFAULT_EXCEPTION_TERM, CodeGenUtils.DEFAULT_OUT_RECORD_TERM(), DEFAULT_DELEGATING_FUTURE_TERM);
        return FunctionCodeGenerator.generateFunction(ctx, name, AsyncCodeGenerator.getFunctionClass(), processCode, (LogicalType)returnType, (LogicalType)inputType, CodeGenUtils.DEFAULT_INPUT1_TERM(), JavaScalaConversionUtil.toScala(Optional.empty()), JavaScalaConversionUtil.toScala(Optional.empty()), CodeGenUtils.DEFAULT_COLLECTOR_TERM(), CodeGenUtils.DEFAULT_CONTEXT_TERM());
    }

    private static Class<AsyncFunction<RowData, RowData>> getFunctionClass() {
        return AsyncFunction.class;
    }

    private static String generateProcessCode(CodeGeneratorContext ctx, RowType inputType, RowType outRowType, List<RexNode> projection, boolean retainHeader, String inputTerm, String collectorTerm, String errorTerm, String recordTerm, String delegatingFutureTerm) {
        projection.forEach(n -> n.accept(new AsyncScalarFunctionsValidator()));
        ExprCodeGenerator exprGenerator = new ExprCodeGenerator(ctx, false).bindInput((LogicalType)inputType, inputTerm, JavaScalaConversionUtil.toScala(Optional.empty()));
        List projectionExprs = projection.stream().map(exprGenerator::generateExpression).collect(Collectors.toList());
        int index = 0;
        StringBuilder metadataInvocations = new StringBuilder();
        StringBuilder asyncInvocation = new StringBuilder();
        if (retainHeader) {
            metadataInvocations.append(String.format("%s.setRowKind(rowKind);\n", delegatingFutureTerm));
        }
        for (GeneratedExpression fieldExpr : projectionExprs) {
            if (fieldExpr.resultTerm().isEmpty()) {
                asyncInvocation.append(fieldExpr.code());
                metadataInvocations.append(String.format("%s.addAsyncIndex(%d);\n", delegatingFutureTerm, index));
            } else {
                metadataInvocations.append(fieldExpr.code());
                metadataInvocations.append(String.format("%s.addSynchronousResult(%d, %s);\n", delegatingFutureTerm, index, fieldExpr.resultTerm()));
            }
            ++index;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("delegatingFutureTerm", delegatingFutureTerm);
        values.put("delegatingFutureType", DelegatingAsyncResultFuture.class.getCanonicalName());
        values.put("collectorTerm", collectorTerm);
        values.put("typeTerm", GenericRowData.class.getCanonicalName());
        values.put("recordTerm", recordTerm);
        values.put("inputTerm", inputTerm);
        values.put("fieldCount", Integer.toString(LogicalTypeChecks.getFieldCount((LogicalType)outRowType)));
        values.put("metadataInvocations", metadataInvocations.toString());
        values.put("asyncInvocation", asyncInvocation.toString());
        values.put("errorTerm", errorTerm);
        return StringSubstitutor.replace((Object)String.join((CharSequence)"\n", "final ${delegatingFutureType} ${delegatingFutureTerm} ", "    = new ${delegatingFutureType}(${collectorTerm}, ${fieldCount});", "final org.apache.flink.types.RowKind rowKind = ${inputTerm}.getRowKind();\n", "try {", "  ${metadataInvocations}", "  ${asyncInvocation}", "", "} catch (Throwable ${errorTerm}) {", "  ${collectorTerm}.completeExceptionally(${errorTerm});", "}"), values);
    }

    private static class AsyncScalarFunctionsValidator
    extends RexVisitorImpl<Void> {
        public AsyncScalarFunctionsValidator() {
            super(true);
        }

        @Override
        public Void visitCall(RexCall call) {
            super.visitCall(call);
            if (call.getOperator() instanceof BridgingSqlFunction && ((BridgingSqlFunction)call.getOperator()).getDefinition().getKind() != FunctionKind.ASYNC_SCALAR) {
                throw new CodeGenException("Invalid use of function " + call.getOperator() + ".Code generation should only be done with async calls");
            }
            return null;
        }
    }
}

