/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.common.hadoop;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.azure.common.hadoop.HadoopBlockLocation;
import org.apache.flink.fs.azure.common.hadoop.HadoopDataInputStream;
import org.apache.flink.fs.azure.common.hadoop.HadoopDataOutputStream;
import org.apache.flink.fs.azure.common.hadoop.HadoopFileStatus;
import org.apache.flink.fs.azure.common.hadoop.HadoopRecoverableWriter;
import org.apache.flink.fs.azure.common.hadoop.LocatedHadoopFileStatus;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.LocatedFileStatus;

public class HadoopFileSystem
extends FileSystem {
    private static final String HDFS_NO_LOCAL_WRITE = "fs.hdfs.no-local-write";
    private final org.apache.hadoop.fs.FileSystem fs;
    private FileSystemKind fsKind;

    public HadoopFileSystem(org.apache.hadoop.fs.FileSystem hadoopFileSystem) {
        this.fs = (org.apache.hadoop.fs.FileSystem)Preconditions.checkNotNull((Object)hadoopFileSystem, (String)"hadoopFileSystem");
    }

    public org.apache.hadoop.fs.FileSystem getHadoopFileSystem() {
        return this.fs;
    }

    public Path getWorkingDirectory() {
        return new Path(this.fs.getWorkingDirectory().toUri());
    }

    public Path getHomeDirectory() {
        return new Path(this.fs.getHomeDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(HadoopFileSystem.toHadoopPath(f));
        return HadoopFileStatus.fromHadoopStatus(status);
    }

    public org.apache.flink.core.fs.BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        if (file instanceof LocatedHadoopFileStatus) {
            return ((LocatedHadoopFileStatus)file).getBlockLocations();
        }
        org.apache.hadoop.fs.FileStatus hadoopStatus = ((HadoopFileStatus)file).getInternalFileStatus();
        BlockLocation[] blkLocations = hadoopStatus instanceof LocatedFileStatus ? ((LocatedFileStatus)hadoopStatus).getBlockLocations() : this.fs.getFileBlockLocations(hadoopStatus, start, len);
        org.apache.flink.core.fs.BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public HadoopDataInputStream open(Path f, int bufferSize) throws IOException {
        org.apache.hadoop.fs.Path path = HadoopFileSystem.toHadoopPath(f);
        FSDataInputStream fdis = this.fs.open(path, bufferSize);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataInputStream open(Path f) throws IOException {
        org.apache.hadoop.fs.Path path = HadoopFileSystem.toHadoopPath(f);
        FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(HadoopFileSystem.toHadoopPath(f), overwrite, bufferSize, replication, blockSize);
        return new HadoopDataOutputStream(fdos);
    }

    public HadoopDataOutputStream create(Path f, FileSystem.WriteMode overwrite) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.fs.create(HadoopFileSystem.toHadoopPath(f), overwrite == FileSystem.WriteMode.OVERWRITE);
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(HadoopFileSystem.toHadoopPath(f), recursive);
    }

    public boolean exists(Path f) throws IOException {
        return this.fs.exists(HadoopFileSystem.toHadoopPath(f));
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(HadoopFileSystem.toHadoopPath(f));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = HadoopFileStatus.fromHadoopStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.fs.mkdirs(HadoopFileSystem.toHadoopPath(f));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(HadoopFileSystem.toHadoopPath(src), HadoopFileSystem.toHadoopPath(dst));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }

    public RecoverableWriter createRecoverableWriter() throws IOException {
        return new HadoopRecoverableWriter(this.fs);
    }

    public RecoverableWriter createRecoverableWriter(Map<String, String> conf) throws IOException {
        if (conf == null || conf.isEmpty()) {
            return this.createRecoverableWriter();
        }
        if (conf.containsKey(HDFS_NO_LOCAL_WRITE)) {
            return new HadoopRecoverableWriter(this.fs, Boolean.parseBoolean(conf.get(HDFS_NO_LOCAL_WRITE)));
        }
        return new HadoopRecoverableWriter(this.fs);
    }

    public static org.apache.hadoop.fs.Path toHadoopPath(Path path) {
        return new org.apache.hadoop.fs.Path(path.toUri());
    }

    static FileSystemKind getKindForScheme(String scheme) {
        if ((scheme = scheme.toLowerCase(Locale.US)).startsWith("s3") || scheme.startsWith("emr") || scheme.startsWith("oss") || scheme.startsWith("wasb") || scheme.startsWith("gs")) {
            return FileSystemKind.OBJECT_STORE;
        }
        if (scheme.startsWith("http") || scheme.startsWith("ftp")) {
            return FileSystemKind.OBJECT_STORE;
        }
        return FileSystemKind.FILE_SYSTEM;
    }
}

