/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.context;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.context.DefaultContext;
import org.apache.flink.table.client.gateway.context.ExecutionContext;
import org.apache.flink.table.client.resource.ClientResourceManager;
import org.apache.flink.table.client.util.ClientClassloaderUtil;
import org.apache.flink.table.client.util.ClientWrapperClassLoader;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionContext {
    private static final Logger LOG = LoggerFactory.getLogger(SessionContext.class);
    private final String sessionId;
    private final DefaultContext defaultContext;
    private final Configuration sessionConfiguration;
    private final SessionState sessionState;
    private final ClientWrapperClassLoader classLoader;
    private ExecutionContext executionContext;

    private SessionContext(DefaultContext defaultContext, String sessionId, Configuration sessionConfiguration, ClientWrapperClassLoader classLoader, SessionState sessionState, ExecutionContext executionContext) {
        this.defaultContext = defaultContext;
        this.sessionId = sessionId;
        this.sessionConfiguration = sessionConfiguration;
        this.classLoader = classLoader;
        this.sessionState = sessionState;
        this.executionContext = executionContext;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public ReadableConfig getReadableConfig() {
        return this.sessionConfiguration;
    }

    public Map<String, String> getConfigMap() {
        return this.sessionConfiguration.toMap();
    }

    @VisibleForTesting
    Set<URL> getDependencies() {
        return this.sessionState.resourceManager.getLocalJarResources();
    }

    public void reset() {
        this.resetSessionConfigurationToDefault(this.defaultContext.getFlinkConfig());
        this.executionContext = new ExecutionContext(this.sessionConfiguration, (MutableURLClassLoader)this.classLoader, this.sessionState);
    }

    public void reset(String key) {
        Configuration configuration = this.defaultContext.getFlinkConfig();
        if (configuration.containsKey(key)) {
            String defaultValue = (String)configuration.get(ConfigOptions.key((String)key).stringType().noDefaultValue());
            this.set(key, defaultValue);
        } else {
            ConfigOption keyToDelete = ConfigOptions.key((String)key).stringType().noDefaultValue();
            this.sessionConfiguration.removeConfig(keyToDelete);
            this.executionContext = new ExecutionContext(this.executionContext);
        }
    }

    public void set(String key, String value) {
        Configuration originConfiguration = this.sessionConfiguration.clone();
        this.sessionConfiguration.setString(key, value);
        try {
            ExecutionContext newContext;
            this.executionContext = newContext = new ExecutionContext(this.executionContext);
        }
        catch (Exception e) {
            this.resetSessionConfigurationToDefault(originConfiguration);
            if (value.equalsIgnoreCase(SqlDialect.HIVE.name()) && e instanceof ValidationException) {
                String additionErrorMsg = "Note: if you want to use Hive dialect, please first move the jar `flink-table-planner_2.12` located in `FLINK_HOME/opt` to `FLINK_HOME/lib` and then move out the jar `flink-table-planner-loader` from `FLINK_HOME/lib`.";
                ExceptionUtils.updateDetailMessage((Throwable)e, t -> t.getMessage() + additionErrorMsg);
            }
            throw new SqlExecutionException(String.format("Failed to set key %s with value %s.", key, value), e);
        }
    }

    public void close() {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)((Object)this.classLoader));){
            for (String name : this.sessionState.catalogManager.listCatalogs()) {
                this.sessionState.catalogManager.getCatalog(name).ifPresent(Catalog::close);
            }
        }
        this.classLoader.close();
        try {
            this.sessionState.resourceManager.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close the resource manager.", (Throwable)e);
        }
    }

    public static SessionContext create(DefaultContext defaultContext, String sessionId) {
        Configuration configuration = defaultContext.getFlinkConfig().clone();
        ClientWrapperClassLoader userClassLoader = new ClientWrapperClassLoader(ClientClassloaderUtil.buildUserClassLoader(defaultContext.getDependencies(), SessionContext.class.getClassLoader(), new Configuration(configuration)), configuration);
        ClientResourceManager resourceManager = new ClientResourceManager(configuration, (MutableURLClassLoader)userClassLoader);
        ModuleManager moduleManager = new ModuleManager();
        EnvironmentSettings settings = EnvironmentSettings.newInstance().withConfiguration(configuration).build();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader((ClassLoader)((Object)userClassLoader)).config((ReadableConfig)configuration).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).build();
        FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)configuration, (ResourceManager)resourceManager, catalogManager, moduleManager);
        SessionState sessionState = new SessionState(catalogManager, moduleManager, resourceManager, functionCatalog);
        ExecutionContext executionContext = new ExecutionContext(configuration, (MutableURLClassLoader)userClassLoader, sessionState);
        return new SessionContext(defaultContext, sessionId, configuration, userClassLoader, sessionState, executionContext);
    }

    public void removeJar(String jarPath) {
        URL jarURL = this.sessionState.resourceManager.unregisterJarResource(jarPath);
        if (jarURL == null) {
            LOG.warn(String.format("Could not remove the specified jar because the jar path [%s] hadn't registered to classloader.", jarPath));
            return;
        }
        this.classLoader.removeURL(jarURL);
    }

    private void resetSessionConfigurationToDefault(Configuration defaultConf) {
        for (String key : this.sessionConfiguration.toMap().keySet()) {
            ConfigOption keyToDelete = ConfigOptions.key((String)key).stringType().noDefaultValue();
            this.sessionConfiguration.removeConfig(keyToDelete);
        }
        this.sessionConfiguration.addAll(defaultConf);
    }

    public static class SessionState {
        public final CatalogManager catalogManager;
        public final ModuleManager moduleManager;
        public final ClientResourceManager resourceManager;
        public final FunctionCatalog functionCatalog;

        public SessionState(CatalogManager catalogManager, ModuleManager moduleManager, ClientResourceManager resourceManager, FunctionCatalog functionCatalog) {
            this.catalogManager = catalogManager;
            this.moduleManager = moduleManager;
            this.resourceManager = resourceManager;
            this.functionCatalog = functionCatalog;
        }
    }
}

