/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.curator5.org.apache.curator;

import java.util.concurrent.Callable;
import org.apache.flink.shaded.curator5.org.apache.curator.CuratorZookeeperClient;
import org.apache.flink.shaded.curator5.org.apache.curator.RetryLoopImpl;
import org.apache.flink.shaded.curator5.org.apache.curator.RetrySleeper;
import org.apache.flink.shaded.curator5.org.apache.curator.connection.ThreadLocalRetryLoop;
import org.apache.flink.shaded.curator5.org.apache.curator.utils.ThreadUtils;

public abstract class RetryLoop {
    public static RetrySleeper getDefaultRetrySleeper() {
        return RetryLoopImpl.getRetrySleeper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T callWithRetry(CuratorZookeeperClient client, Callable<T> proc) throws Exception {
        client.internalBlockUntilConnectedOrTimedOut();
        T result = null;
        ThreadLocalRetryLoop threadLocalRetryLoop = new ThreadLocalRetryLoop();
        RetryLoop retryLoop = threadLocalRetryLoop.getRetryLoop(client::newRetryLoop);
        try {
            while (retryLoop.shouldContinue()) {
                try {
                    result = proc.call();
                    retryLoop.markComplete();
                }
                catch (Exception e) {
                    ThreadUtils.checkInterrupted(e);
                    retryLoop.takeException(e);
                }
            }
        }
        finally {
            threadLocalRetryLoop.release();
        }
        return result;
    }

    public abstract boolean shouldContinue();

    public abstract void markComplete();

    public abstract void takeException(Exception var1) throws Exception;
}

