/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.table.client.cli.CliClient;
import org.apache.flink.table.client.cli.CliStrings;
import org.apache.flink.table.client.cli.CliView;
import org.jline.keymap.KeyMap;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class CliRowView
extends CliView<RowOperation, Void> {
    private String[] columnNames;
    private String[] columnTypes;
    private String[] row;

    public CliRowView(CliClient client, String[] columnNames, String[] columnTypes, String[] row) {
        super(client);
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.row = row;
    }

    @Override
    protected void init() {
    }

    @Override
    protected KeyMap<RowOperation> getKeys() {
        KeyMap<RowOperation> keys = new KeyMap<RowOperation>();
        keys.setAmbiguousTimeout(200L);
        keys.bind(RowOperation.QUIT, "q", "Q", KeyMap.esc());
        keys.bind(RowOperation.UP, "w", "W", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_up));
        keys.bind(RowOperation.DOWN, "s", "S", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_down));
        keys.bind(RowOperation.LEFT, "a", "A", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_left));
        keys.bind(RowOperation.RIGHT, "d", "D", KeyMap.key(this.client.getTerminal(), InfoCmp.Capability.key_right));
        return keys;
    }

    @Override
    protected void evaluate(RowOperation operation, String binding) {
        switch (operation) {
            case QUIT: {
                this.close();
                break;
            }
            case UP: {
                this.scrollUp();
                break;
            }
            case DOWN: {
                this.scrollDown();
                break;
            }
            case LEFT: {
                this.scrollLeft();
                break;
            }
            case RIGHT: {
                this.scrollRight();
            }
        }
    }

    @Override
    protected String getTitle() {
        return "Row Summary";
    }

    @Override
    protected List<AttributedString> computeHeaderLines() {
        return Collections.singletonList(AttributedString.EMPTY);
    }

    @Override
    protected List<AttributedString> computeFooterLines() {
        return Collections.singletonList(CliStrings.ROW_QUIT);
    }

    @Override
    protected List<AttributedString> computeMainHeaderLines() {
        return Collections.emptyList();
    }

    @Override
    protected List<AttributedString> computeMainLines() {
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>();
        AttributedStringBuilder sb = new AttributedStringBuilder();
        IntStream.range(0, this.row.length).forEach(i -> {
            String name = this.columnNames[i];
            String type = this.columnTypes[i];
            sb.setLength(0);
            sb.append(" ");
            sb.style(AttributedStyle.BOLD);
            sb.append(name);
            sb.append(" (");
            sb.append(type);
            sb.append(')');
            sb.append(':');
            lines.add(sb.toAttributedString());
            sb.setLength(0);
            sb.append(" ");
            sb.style(AttributedStyle.DEFAULT);
            sb.append(this.row[i]);
            lines.add(sb.toAttributedString());
            lines.add(AttributedString.EMPTY);
        });
        return lines;
    }

    @Override
    protected void cleanUp() {
    }

    public static enum RowOperation {
        QUIT,
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

