/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.context;

import java.lang.reflect.Method;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.client.gateway.context.SessionContext;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.util.MutableURLClassLoader;

public class ExecutionContext {
    private final Configuration flinkConfig;
    private final SessionContext.SessionState sessionState;
    private final MutableURLClassLoader classLoader;
    private final StreamTableEnvironment tableEnv;

    public ExecutionContext(Configuration flinkConfig, MutableURLClassLoader classLoader, SessionContext.SessionState sessionState) {
        this.flinkConfig = flinkConfig;
        this.sessionState = sessionState;
        this.classLoader = classLoader;
        this.tableEnv = this.createTableEnvironment();
    }

    public ExecutionContext(ExecutionContext context) {
        this.flinkConfig = context.flinkConfig;
        this.sessionState = context.sessionState;
        this.classLoader = context.classLoader;
        this.tableEnv = this.createTableEnvironment();
    }

    public StreamTableEnvironment getTableEnvironment() {
        return this.tableEnv;
    }

    private StreamTableEnvironment createTableEnvironment() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().withConfiguration(this.flinkConfig).build();
        StreamExecutionEnvironment streamExecEnv = new StreamExecutionEnvironment(new Configuration(this.flinkConfig), (ClassLoader)this.classLoader);
        Executor executor = ExecutionContext.lookupExecutor(streamExecEnv, (ClassLoader)this.classLoader);
        return ExecutionContext.createStreamTableEnvironment(streamExecEnv, settings, executor, this.sessionState.catalogManager, this.sessionState.moduleManager, this.sessionState.resourceManager, this.sessionState.functionCatalog, (ClassLoader)this.classLoader);
    }

    private static StreamTableEnvironment createStreamTableEnvironment(StreamExecutionEnvironment env, EnvironmentSettings settings, Executor executor, CatalogManager catalogManager, ModuleManager moduleManager, ResourceManager resourceManager, FunctionCatalog functionCatalog, ClassLoader userClassLoader) {
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setRootConfiguration(executor.getConfiguration());
        tableConfig.addConfiguration(settings.getConfiguration());
        Planner planner = PlannerFactoryUtil.createPlanner((Executor)executor, (TableConfig)tableConfig, (ClassLoader)userClassLoader, (ModuleManager)moduleManager, (CatalogManager)catalogManager, (FunctionCatalog)functionCatalog);
        return new StreamTableEnvironmentImpl(catalogManager, moduleManager, resourceManager, functionCatalog, tableConfig, env, planner, executor, settings.isStreamingMode());
    }

    private static Executor lookupExecutor(StreamExecutionEnvironment executionEnvironment, ClassLoader userClassLoader) {
        try {
            ExecutorFactory executorFactory = (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)userClassLoader, ExecutorFactory.class, (String)"default");
            Method createMethod = executorFactory.getClass().getMethod("create", StreamExecutionEnvironment.class);
            return (Executor)createMethod.invoke((Object)executorFactory, executionEnvironment);
        }
        catch (Exception e) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", (Throwable)e);
        }
    }
}

