/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.table.client.SqlClientException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.DumbTerminal;

public class TerminalUtils {
    private TerminalUtils() {
    }

    public static Terminal createDumbTerminal() {
        return TerminalUtils.createDumbTerminal(new MockOutputStream());
    }

    public static Terminal createDumbTerminal(OutputStream out) {
        try {
            return new DumbTerminal(new MockInputStream(), out);
        }
        catch (IOException e) {
            throw new SqlClientException("Unable to create dummy terminal.", e);
        }
    }

    public static Terminal createDumbTerminal(InputStream in, OutputStream out) {
        try {
            return new DumbTerminal(in, out);
        }
        catch (IOException e) {
            throw new SqlClientException("Unable to create dummy terminal.", e);
        }
    }

    public static Terminal createDefaultTerminal() {
        try {
            return TerminalBuilder.builder().name("Flink SQL CLI Client").build();
        }
        catch (IOException e) {
            throw new SqlClientException("Error opening command line interface.", e);
        }
    }

    public static class MockOutputStream
    extends OutputStream {
        @Override
        public void write(int b) {
        }
    }

    private static class MockInputStream
    extends InputStream {
        private MockInputStream() {
        }

        @Override
        public int read() {
            return 0;
        }
    }
}

