/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.impl.StreamFormatAdapter;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.table.factories.BulkReaderFormatFactory;
import org.apache.flink.connector.file.table.factories.BulkWriterFormatFactory;
import org.apache.flink.connector.file.table.format.BulkDecodingFormat;
import org.apache.flink.formats.csv.CsvBulkWriter;
import org.apache.flink.formats.csv.CsvCommons;
import org.apache.flink.formats.csv.CsvFormatOptions;
import org.apache.flink.formats.csv.CsvReaderFormat;
import org.apache.flink.formats.csv.CsvRowSchemaConverter;
import org.apache.flink.formats.csv.CsvToRowDataConverters;
import org.apache.flink.formats.csv.RowDataToCsvConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ContainerNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@Internal
public class CsvFileFormatFactory
implements BulkReaderFormatFactory,
BulkWriterFormatFactory {
    public String factoryIdentifier() {
        return "csv";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return CsvCommons.optionalOptions();
    }

    public Set<ConfigOption<?>> forwardOptions() {
        return CsvCommons.forwardOptions();
    }

    public BulkDecodingFormat<RowData> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        return new CsvBulkDecodingFormat(formatOptions);
    }

    public EncodingFormat<BulkWriter.Factory<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        return new EncodingFormat<BulkWriter.Factory<RowData>>(){

            public BulkWriter.Factory<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType physicalDataType) {
                RowType rowType = (RowType)physicalDataType.getLogicalType();
                CsvSchema schema = CsvFileFormatFactory.buildCsvSchema(rowType, formatOptions);
                RowDataToCsvConverters.RowDataToCsvConverter converter = RowDataToCsvConverters.createRowConverter(rowType);
                CsvMapper mapper = new CsvMapper();
                ObjectNode container = mapper.createObjectNode();
                RowDataToCsvConverters.RowDataToCsvConverter.RowDataToCsvFormatConverterContext converterContext = new RowDataToCsvConverters.RowDataToCsvConverter.RowDataToCsvFormatConverterContext(mapper, (ContainerNode<?>)container);
                return (BulkWriter.Factory & Serializable)out -> CsvBulkWriter.forSchema(mapper, schema, converter, converterContext, out);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    private static CsvSchema buildCsvSchema(RowType rowType, ReadableConfig options) {
        CsvSchema csvSchema = CsvRowSchemaConverter.convert(rowType);
        CsvSchema.Builder csvBuilder = csvSchema.rebuild();
        options.getOptional(CsvFormatOptions.FIELD_DELIMITER).map(s -> Character.valueOf(StringEscapeUtils.unescapeJava((String)s).charAt(0))).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setColumnSeparator(arg_0));
        if (((Boolean)options.get(CsvFormatOptions.DISABLE_QUOTE_CHARACTER)).booleanValue()) {
            csvBuilder.disableQuoteChar();
        } else {
            options.getOptional(CsvFormatOptions.QUOTE_CHARACTER).map(s -> Character.valueOf(s.charAt(0))).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setQuoteChar(arg_0));
        }
        options.getOptional(CsvFormatOptions.ALLOW_COMMENTS).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setAllowComments(arg_0));
        options.getOptional(CsvFormatOptions.ARRAY_ELEMENT_DELIMITER).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setArrayElementSeparator(arg_0));
        options.getOptional(CsvFormatOptions.ESCAPE_CHARACTER).map(s -> Character.valueOf(s.charAt(0))).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setEscapeChar(arg_0));
        options.getOptional(CsvFormatOptions.NULL_LITERAL).ifPresent(arg_0 -> ((CsvSchema.Builder)csvBuilder).setNullValue(arg_0));
        return csvBuilder.build();
    }

    private static class CsvBulkDecodingFormat
    implements BulkDecodingFormat<RowData>,
    ProjectableDecodingFormat<BulkFormat<RowData, FileSourceSplit>> {
        private final ReadableConfig formatOptions;

        public CsvBulkDecodingFormat(ReadableConfig formatOptions) {
            Preconditions.checkNotNull((Object)formatOptions);
            this.formatOptions = formatOptions;
        }

        public BulkFormat<RowData, FileSourceSplit> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType, int[][] projections) {
            DataType projectedDataType = Projection.of((int[][])projections).project(physicalDataType);
            RowType projectedRowType = (RowType)projectedDataType.getLogicalType();
            RowType physicalRowType = (RowType)physicalDataType.getLogicalType();
            CsvSchema schema = CsvFileFormatFactory.buildCsvSchema(physicalRowType, this.formatOptions);
            boolean ignoreParseErrors = this.formatOptions.getOptional(CsvFormatOptions.IGNORE_PARSE_ERRORS).isPresent();
            CsvToRowDataConverters.CsvToRowDataConverter converter = new CsvToRowDataConverters(ignoreParseErrors).createRowConverter(projectedRowType, true);
            CsvReaderFormat<Object> csvReaderFormat = new CsvReaderFormat<Object>(new CsvMapper(), schema, JsonNode.class, converter, context.createTypeInformation(projectedDataType), ignoreParseErrors);
            return new StreamFormatAdapter(csvReaderFormat);
        }

        public ChangelogMode getChangelogMode() {
            return ChangelogMode.insertOnly();
        }
    }
}

