/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliOptions;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.context.DefaultContext;
import org.apache.flink.table.client.gateway.context.SessionContext;
import org.apache.flink.util.JarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LocalContextUtils.class);
    private static final String DEFAULT_SESSION_ID = "default";

    public static DefaultContext buildDefaultContext(CliOptions options) {
        List<URL> jars = options.getJars() != null ? options.getJars() : Collections.emptyList();
        List<URL> libDirs = options.getLibraryDirs() != null ? options.getLibraryDirs() : Collections.emptyList();
        String flinkConfigDir = CliFrontend.getConfigurationDirectoryFromEnv();
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)flinkConfigDir);
        List commandLines = CliFrontend.loadCustomCommandLines((Configuration)configuration, (String)flinkConfigDir);
        configuration.addAll(options.getPythonConfiguration());
        List<URL> dependencies = LocalContextUtils.discoverDependencies(jars, libDirs);
        return new DefaultContext(dependencies, configuration, commandLines);
    }

    public static SessionContext buildSessionContext(@Nullable String sessionId, DefaultContext defaultContext) {
        SessionContext context = sessionId == null ? SessionContext.create(defaultContext, DEFAULT_SESSION_ID) : SessionContext.create(defaultContext, sessionId);
        return context;
    }

    private static List<URL> discoverDependencies(List<URL> jars, List<URL> libraries) {
        ArrayList<URL> dependencies = new ArrayList<URL>();
        try {
            for (URL url : jars) {
                JarUtils.checkJarFile((URL)url);
                dependencies.add(url);
            }
            for (URL libUrl : libraries) {
                File dir = new File(libUrl.toURI());
                if (!dir.isDirectory()) {
                    throw new SqlClientException("Directory expected: " + dir);
                }
                if (!dir.canRead()) {
                    throw new SqlClientException("Directory cannot be read: " + dir);
                }
                File[] files = dir.listFiles();
                if (files == null) {
                    throw new SqlClientException("Directory cannot be read: " + dir);
                }
                for (File f : files) {
                    if (!f.isFile() || !f.getAbsolutePath().toLowerCase().endsWith(".jar")) continue;
                    URL url = f.toURI().toURL();
                    JarUtils.checkJarFile((URL)url);
                    dependencies.add(url);
                }
            }
        }
        catch (Exception e) {
            throw new SqlClientException("Could not load all required JAR files.", e);
        }
        try {
            URL location = Class.forName("org.apache.flink.python.PythonFunctionRunner", false, Thread.currentThread().getContextClassLoader()).getProtectionDomain().getCodeSource().getLocation();
            if (Paths.get(location.toURI()).toFile().isFile()) {
                dependencies.add(location);
            }
        }
        catch (ClassNotFoundException | URISyntaxException e) {
            throw new SqlExecutionException("Don't find python dependencies. Please add the flink-python jar via `--jar` command option manually.", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using the following dependencies: {}", dependencies);
        }
        return dependencies;
    }
}

