/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.List;
import java.util.Optional;
import org.apache.flink.table.api.SqlParserEOFException;
import org.apache.flink.table.client.cli.SqlCommandParser;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.operations.Operation;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.DefaultParser;

class SqlMultiLineParser
extends DefaultParser {
    private static final String STATEMENT_DELIMITER = ";";
    private static final String LINE_DELIMITER = "\n";
    private static final String NEW_LINE_PROMPT = "";
    private final SqlCommandParser parser;
    private Throwable parseException = null;
    private Operation parsedOperation = null;
    private String command;

    public SqlMultiLineParser(SqlCommandParser parser) {
        this.parser = parser;
        this.setEscapeChars(null);
        this.setQuoteChars(null);
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        if (context != Parser.ParseContext.ACCEPT_LINE) {
            return this.parseInternal(line, cursor, context);
        }
        if (!line.trim().endsWith(STATEMENT_DELIMITER)) {
            throw new EOFError(-1, -1, "New line without EOF character.", NEW_LINE_PROMPT);
        }
        try {
            this.command = line;
            this.parseException = null;
            this.parsedOperation = this.parser.parseCommand(line).orElse(null);
        }
        catch (SqlExecutionException e) {
            if (e.getCause() instanceof SqlParserEOFException) {
                throw new EOFError(-1, -1, "The statement is incomplete.", NEW_LINE_PROMPT);
            }
            this.parseException = e;
            throw new SyntaxError(-1, -1, e.getMessage());
        }
        return this.parseInternal(line, cursor, context);
    }

    public static String formatSqlFile(String content) {
        String trimmed = content.trim();
        StringBuilder formatted = new StringBuilder();
        formatted.append(trimmed);
        if (!trimmed.endsWith(STATEMENT_DELIMITER)) {
            formatted.append(STATEMENT_DELIMITER);
        }
        formatted.append(LINE_DELIMITER);
        return formatted.toString();
    }

    private SqlArgumentList parseInternal(String line, int cursor, Parser.ParseContext context) {
        DefaultParser.ArgumentList parsedLine = (DefaultParser.ArgumentList)super.parse(line, cursor, context);
        return new SqlArgumentList(parsedLine.line(), parsedLine.words(), parsedLine.wordIndex(), parsedLine.wordCursor(), parsedLine.cursor(), null, parsedLine.rawWordCursor(), parsedLine.rawWordLength());
    }

    public Optional<Operation> getParsedOperation() throws Throwable {
        if (this.parseException != null) {
            throw this.parseException;
        }
        return Optional.ofNullable(this.parsedOperation);
    }

    public String getCommand() {
        return this.command;
    }

    private class SqlArgumentList
    extends DefaultParser.ArgumentList {
        public SqlArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor, String openingQuote, int rawWordCursor, int rawWordLength) {
            super(SqlMultiLineParser.this, line, words, wordIndex, wordCursor, cursor, openingQuote, rawWordCursor, rawWordLength);
        }

        @Override
        public CharSequence escape(CharSequence candidate, boolean complete) {
            return candidate;
        }
    }
}

