/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.shuffle;

import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaException;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.PropertiesUtil;
import org.apache.kafka.clients.producer.ProducerRecord;

@Internal
public class FlinkKafkaShuffleProducer<IN, KEY>
extends FlinkKafkaProducer<IN> {
    private final KafkaSerializer<IN> kafkaSerializer;
    private final KeySelector<IN, KEY> keySelector;
    private final int numberOfPartitions;

    FlinkKafkaShuffleProducer(String defaultTopicId, TypeSerializer<IN> typeSerializer, Properties props, KeySelector<IN, KEY> keySelector, FlinkKafkaProducer.Semantic semantic, int kafkaProducersPoolSize) {
        super(defaultTopicId, (element, timestamp) -> null, props, semantic, kafkaProducersPoolSize);
        this.kafkaSerializer = new KafkaSerializer<IN>(typeSerializer);
        this.keySelector = keySelector;
        Preconditions.checkArgument((props.getProperty("partition number") != null ? 1 : 0) != 0, (Object)"Missing partition number for Kafka Shuffle");
        this.numberOfPartitions = PropertiesUtil.getInt((Properties)props, (String)"partition number", (int)Integer.MIN_VALUE);
    }

    @Override
    public void invoke(FlinkKafkaProducer.KafkaTransactionState transaction, IN next, SinkFunction.Context context) throws FlinkKafkaException {
        int partitionIndex;
        this.checkErroneous();
        Long timestamp = context.timestamp();
        int[] partitions = this.getPartitions(transaction);
        try {
            partitionIndex = KeyGroupRangeAssignment.assignKeyToParallelOperator((Object)this.keySelector.getKey(next), (int)partitions.length, (int)partitions.length);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to assign a partition number to record", e);
        }
        ProducerRecord<Object, byte[]> record = new ProducerRecord<Object, byte[]>(this.defaultTopicId, (Integer)partitionIndex, timestamp, null, this.kafkaSerializer.serializeRecord(next, timestamp));
        this.pendingRecords.incrementAndGet();
        transaction.getProducer().send(record, this.callback);
    }

    public void invoke(Watermark watermark) throws FlinkKafkaException {
        this.checkErroneous();
        FlinkKafkaProducer.KafkaTransactionState transaction = (FlinkKafkaProducer.KafkaTransactionState)this.currentTransaction();
        int[] partitions = this.getPartitions(transaction);
        int subtask = this.getRuntimeContext().getIndexOfThisSubtask();
        long timestamp = watermark.getTimestamp();
        for (int partition : partitions) {
            ProducerRecord<Object, byte[]> record = new ProducerRecord<Object, byte[]>(this.defaultTopicId, (Integer)partition, timestamp, null, this.kafkaSerializer.serializeWatermark(watermark, subtask));
            this.pendingRecords.incrementAndGet();
            transaction.getProducer().send(record, this.callback);
        }
    }

    private int[] getPartitions(FlinkKafkaProducer.KafkaTransactionState transaction) {
        int[] partitions = (int[])this.topicPartitionsMap.get(this.defaultTopicId);
        if (partitions == null) {
            partitions = FlinkKafkaShuffleProducer.getPartitionsByTopic(this.defaultTopicId, transaction.getProducer());
            this.topicPartitionsMap.put(this.defaultTopicId, partitions);
        }
        Preconditions.checkArgument((partitions.length == this.numberOfPartitions ? 1 : 0) != 0);
        return partitions;
    }

    public static final class KafkaSerializer<IN>
    implements Serializable {
        public static final int TAG_REC_WITH_TIMESTAMP = 0;
        public static final int TAG_REC_WITHOUT_TIMESTAMP = 1;
        public static final int TAG_WATERMARK = 2;
        private static final long serialVersionUID = 2000002L;
        private static final int KAFKA_SHUFFLE_VERSION = 0;
        private final TypeSerializer<IN> serializer;
        private transient DataOutputSerializer dos;

        KafkaSerializer(TypeSerializer<IN> serializer) {
            this.serializer = serializer;
        }

        byte[] serializeRecord(IN record, Long timestamp) {
            if (this.dos == null) {
                this.dos = new DataOutputSerializer(16);
            }
            try {
                this.dos.write(0);
                if (timestamp == null) {
                    this.dos.write(1);
                } else {
                    this.dos.write(0);
                    this.dos.writeLong(timestamp.longValue());
                }
                this.serializer.serialize(record, (DataOutputView)this.dos);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to serialize record", e);
            }
            byte[] ret = this.dos.getCopyOfBuffer();
            this.dos.clear();
            return ret;
        }

        byte[] serializeWatermark(Watermark watermark, int subtask) {
            if (this.dos == null) {
                this.dos = new DataOutputSerializer(16);
            }
            try {
                this.dos.write(0);
                this.dos.write(2);
                this.dos.writeInt(subtask);
                this.dos.writeLong(watermark.getTimestamp());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to serialize watermark", e);
            }
            byte[] ret = this.dos.getCopyOfBuffer();
            this.dos.clear();
            return ret;
        }
    }
}

