/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples.data;

import java.util.ArrayList;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;

public class SummarizationData {
    private static final String[] INPUT_VERTICES = new String[]{"0;1", "1;1", "2;2", "3;2", "4;2", "5;3"};
    private static final String[] INPUT_EDGES = new String[]{"0;1;1", "1;0;1", "1;2;1", "2;1;1", "2;3;2", "3;2;2", "4;0;3", "4;1;3", "5;2;4", "5;3;4"};
    public static final String[] EXPECTED_VERTICES = new String[]{"0,1;1,2", "2,3,4;2,3", "5;3,1"};
    public static final String[] EXPECTED_EDGES_WITH_VALUES = new String[]{"0,1;0,1;1,2", "0,1;2,3,4;1,1", "2,3,4;0,1;1,1", "2,3,4;0,1;3,2", "2,3,4;2,3,4;2,2", "5;2,3,4;4,2"};
    public static final String[] EXPECTED_EDGES_ABSENT_VALUES = new String[]{"0,1;0,1;(null),2", "0,1;2,3,4;(null),1", "2,3,4;0,1;(null),3", "2,3,4;2,3,4;(null),2", "5;2,3,4;(null),2"};

    private SummarizationData() {
    }

    public static DataSet<Vertex<Long, String>> getVertices(ExecutionEnvironment env) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(INPUT_VERTICES.length);
        for (String vertex : INPUT_VERTICES) {
            String[] tokens = vertex.split(";");
            vertices.add(new Vertex((Object)Long.parseLong(tokens[0]), (Object)tokens[1]));
        }
        return env.fromCollection(vertices);
    }

    public static DataSet<Edge<Long, String>> getEdges(ExecutionEnvironment env) {
        ArrayList<Edge> edges = new ArrayList<Edge>(INPUT_EDGES.length);
        for (String edge : INPUT_EDGES) {
            String[] tokens = edge.split(";");
            edges.add(new Edge((Object)Long.parseLong(tokens[0]), (Object)Long.parseLong(tokens[1]), (Object)tokens[2]));
        }
        return env.fromCollection(edges);
    }
}

