/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples;

import java.io.Serializable;
import org.apache.flink.api.common.ProgramDescription;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.EdgeJoinFunction;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Triplet;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.examples.data.EuclideanGraphData;

public class EuclideanGraphWeighing
implements ProgramDescription {
    private static boolean fileOutput = false;
    private static String verticesInputPath = null;
    private static String edgesInputPath = null;
    private static String outputPath = null;

    public static void main(String[] args) throws Exception {
        if (!EuclideanGraphWeighing.parseParameters(args)) {
            return;
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSet<Vertex<Long, Point>> vertices = EuclideanGraphWeighing.getVerticesDataSet(env);
        DataSet<Edge<Long, Double>> edges = EuclideanGraphWeighing.getEdgesDataSet(env);
        Graph graph = Graph.fromDataSet(vertices, edges, (ExecutionEnvironment)env);
        MapOperator edgesWithEuclideanWeight = graph.getTriplets().map((MapFunction)new MapFunction<Triplet<Long, Point, Double>, Tuple3<Long, Long, Double>>(){

            public Tuple3<Long, Long, Double> map(Triplet<Long, Point, Double> triplet) throws Exception {
                Vertex srcVertex = triplet.getSrcVertex();
                Vertex trgVertex = triplet.getTrgVertex();
                return new Tuple3(srcVertex.getId(), trgVertex.getId(), (Object)((Point)srcVertex.getValue()).euclideanDistance((Point)trgVertex.getValue()));
            }
        });
        Graph resultedGraph = graph.joinWithEdges((DataSet)edgesWithEuclideanWeight, (EdgeJoinFunction)new EdgeJoinFunction<Double, Double>(){

            public Double edgeJoin(Double edgeValue, Double inputValue) {
                return inputValue;
            }
        });
        DataSet result = resultedGraph.getEdges();
        if (fileOutput) {
            result.writeAsCsv(outputPath, "\n", ",");
            env.execute("Euclidean Graph Weighing Example");
        } else {
            result.print();
        }
    }

    public String getDescription() {
        return "Weighing a graph by computing the Euclidean distance between its vertices";
    }

    private static boolean parseParameters(String[] args) {
        if (args.length > 0) {
            if (args.length == 3) {
                fileOutput = true;
                verticesInputPath = args[0];
                edgesInputPath = args[1];
                outputPath = args[2];
            } else {
                System.out.println("Executing Euclidean Graph Weighing example with default parameters and built-in default data.");
                System.out.println("Provide parameters to read input data from files.");
                System.out.println("See the documentation for the correct format of input files.");
                System.err.println("Usage: EuclideanGraphWeighing <input vertices path> <input edges path> <output path>");
                return false;
            }
        }
        return true;
    }

    private static DataSet<Vertex<Long, Point>> getVerticesDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(verticesInputPath).lineDelimiter("\n").types(Long.class, Double.class, Double.class).map((MapFunction)new MapFunction<Tuple3<Long, Double, Double>, Vertex<Long, Point>>(){

                public Vertex<Long, Point> map(Tuple3<Long, Double, Double> value) throws Exception {
                    return new Vertex(value.f0, (Object)new Point((Double)value.f1, (Double)value.f2));
                }
            });
        }
        return EuclideanGraphData.getDefaultVertexDataSet(env);
    }

    private static DataSet<Edge<Long, Double>> getEdgesDataSet(ExecutionEnvironment env) {
        if (fileOutput) {
            return env.readCsvFile(edgesInputPath).lineDelimiter("\n").types(Long.class, Long.class).map((MapFunction)new MapFunction<Tuple2<Long, Long>, Edge<Long, Double>>(){

                public Edge<Long, Double> map(Tuple2<Long, Long> tuple2) throws Exception {
                    return new Edge(tuple2.f0, tuple2.f1, (Object)0.0);
                }
            });
        }
        return EuclideanGraphData.getDefaultEdgeDataSet(env);
    }

    public static class Point
    implements Serializable {
        public double x;
        public double y;

        public Point() {
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double euclideanDistance(Point other) {
            return Math.sqrt((this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y));
        }

        public String toString() {
            return this.x + " " + this.y;
        }
    }
}

