/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.graph.drivers.parameter.ParameterizedBase;
import org.apache.flink.graph.drivers.parameter.SimpleParameter;
import org.apache.flink.util.Preconditions;

public class ChoiceParameter
extends SimpleParameter<String> {
    private List<String> choices = new ArrayList<String>();
    private List<String> hiddenChoices = new ArrayList<String>();

    public ChoiceParameter(ParameterizedBase owner, String name) {
        super(owner, name);
    }

    public ChoiceParameter setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.choices.add(defaultValue);
        return this;
    }

    public ChoiceParameter addChoices(String ... choices) {
        Collections.addAll(this.choices, choices);
        return this;
    }

    public ChoiceParameter addHiddenChoices(String ... hiddenChoices) {
        Collections.addAll(this.hiddenChoices, hiddenChoices);
        return this;
    }

    @Override
    public String getUsage() {
        String option = new StrBuilder().append("--").append(this.name).append(" <").append(StringUtils.join(this.choices, (String)" | ")).append(">").toString();
        return this.hasDefaultValue ? "[" + option + "]" : option;
    }

    @Override
    public void configure(ParameterTool parameterTool) {
        Preconditions.checkArgument((this.choices.size() > 0 ? 1 : 0) != 0, (Object)"No choices provided");
        String selected = parameterTool.get(this.name);
        if (selected == null) {
            if (this.hasDefaultValue) {
                this.value = this.defaultValue;
                return;
            }
            throw new ProgramParametrizationException("Must select a choice for option '" + this.name + "': '[" + StringUtils.join(this.choices, (String)", ") + "]'");
        }
        for (String choice : this.choices) {
            if (!choice.equals(selected)) continue;
            this.value = selected;
            return;
        }
        for (String choice : this.hiddenChoices) {
            if (!choice.equals(selected)) continue;
            this.value = selected;
            return;
        }
        throw new ProgramParametrizationException("Selection '" + selected + "' for option '" + this.name + "' is not in choices '[" + StringUtils.join(this.choices, (String)", ") + "]'");
    }

    public String toString() {
        return (String)this.value;
    }
}

