/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.output;

import java.io.PrintStream;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.graph.drivers.output.OutputBase;
import org.apache.flink.graph.drivers.parameter.StringParameter;

public class CSV<T>
extends OutputBase<T> {
    private StringParameter filename = new StringParameter(this, "output_filename");
    private StringParameter lineDelimiter = new StringParameter(this, "output_line_delimiter").setDefaultValue("\n");
    private StringParameter fieldDelimiter = new StringParameter(this, "output_field_delimiter").setDefaultValue(CsvOutputFormat.DEFAULT_FIELD_DELIMITER);

    @Override
    public void write(String executionName, PrintStream out, DataSet<T> data) throws Exception {
        if (Tuple.class.isAssignableFrom(data.getType().getTypeClass())) {
            data.writeAsCsv((String)this.filename.getValue(), (String)this.lineDelimiter.getValue(), (String)this.fieldDelimiter.getValue()).name("CSV: " + (String)this.filename.getValue());
        } else {
            data.writeAsText((String)this.filename.getValue()).name("CSV: " + (String)this.filename.getValue());
        }
        data.getExecutionEnvironment().execute();
    }
}

