/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.input;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.client.program.ProgramParametrizationException;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.drivers.input.GeneratedGraph;
import org.apache.flink.graph.drivers.parameter.LongParameter;
import org.apache.flink.graph.generator.CirculantGraph;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;

public class CirculantGraph
extends GeneratedGraph<LongValue> {
    private static final String PREFIX = "range";
    private LongParameter vertexCount = new LongParameter(this, "vertex_count").setMinimumValue(2L);
    private List<CirculantGraph.OffsetRange> offsetRanges = new ArrayList<CirculantGraph.OffsetRange>();

    @Override
    public String getUsage() {
        return "--range0 offset:length [--range1 offset:length [--range2 ...]] " + super.getUsage();
    }

    @Override
    public void configure(ParameterTool parameterTool) throws ProgramParametrizationException {
        super.configure(parameterTool);
        TreeMap<Integer, String> offsetRangeMap = new TreeMap<Integer, String>();
        for (String key : parameterTool.toMap().keySet()) {
            if (!key.startsWith(PREFIX)) continue;
            int offsetId = Integer.parseInt(key.substring(PREFIX.length()));
            offsetRangeMap.put(offsetId, parameterTool.get(key));
        }
        for (String field : offsetRangeMap.values()) {
            ProgramParametrizationException exception = new ProgramParametrizationException("Circulant offset range must use a colon to separate the integer offset and integer length:" + field + "'");
            if (!field.contains(":")) {
                throw exception;
            }
            String[] parts = field.split(":");
            if (parts.length != 2) {
                throw exception;
            }
            try {
                long offset = Long.parseLong(parts[0]);
                long length = Long.parseLong(parts[1]);
                this.offsetRanges.add(new CirculantGraph.OffsetRange(offset, length));
            }
            catch (NumberFormatException ex) {
                throw exception;
            }
        }
    }

    @Override
    public String getIdentity() {
        return this.getName() + " (" + this.offsetRanges + ")";
    }

    @Override
    protected long vertexCount() {
        return (Long)this.vertexCount.getValue();
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> create(ExecutionEnvironment env) {
        org.apache.flink.graph.generator.CirculantGraph graph = new org.apache.flink.graph.generator.CirculantGraph(env, ((Long)this.vertexCount.getValue()).longValue());
        for (CirculantGraph.OffsetRange offsetRange : this.offsetRanges) {
            graph.addRange(offsetRange.getOffset(), offsetRange.getLength());
        }
        return graph.setParallelism(((Long)this.parallelism.getValue()).intValue()).generate();
    }
}

