/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers;

import org.apache.commons.lang3.text.StrBuilder;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.drivers.DriverBase;
import org.apache.flink.graph.drivers.parameter.BooleanParameter;
import org.apache.flink.graph.drivers.parameter.DoubleParameter;
import org.apache.flink.graph.drivers.parameter.IterationConvergence;

public class PageRank<K, VV, EV>
extends DriverBase<K, VV, EV> {
    private static final int DEFAULT_ITERATIONS = 10;
    private DoubleParameter dampingFactor = new DoubleParameter(this, "damping_factor").setDefaultValue(0.85).setMinimumValue(0.0, false).setMaximumValue(1.0, false);
    private IterationConvergence iterationConvergence = new IterationConvergence(this, 10);
    private BooleanParameter includeZeroDegreeVertices = new BooleanParameter(this, "__include_zero_degree_vertices");

    @Override
    public String getShortDescription() {
        return "score vertices by the number and quality of incoming links";
    }

    @Override
    public String getLongDescription() {
        return new StrBuilder().appendln("PageRank computes a per-vertex score which is the sum of PageRank scores transmitted over in-edges. Each vertex's score is divided evenly among out-edges. High-scoring vertices are linked to by other high-scoring vertices.").appendNewLine().append("The result contains the vertex ID and PageRank score.").toString();
    }

    @Override
    public DataSet plan(Graph<K, VV, EV> graph) throws Exception {
        return (DataSet)graph.run((GraphAlgorithm)new org.apache.flink.graph.library.linkanalysis.PageRank(((Double)this.dampingFactor.getValue()).doubleValue(), this.iterationConvergence.getValue().iterations, this.iterationConvergence.getValue().convergenceThreshold).setIncludeZeroDegreeVertices(((Boolean)this.includeZeroDegreeVertices.getValue()).booleanValue()).setParallelism(((Long)this.parallelism.getValue()).intValue()));
    }
}

