/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.client;

import java.io.File;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.common.ZKConfig;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ZKClientConfig
extends ZKConfig {
    public static final String ZK_SASL_CLIENT_USERNAME = "zookeeper.sasl.client.username";
    public static final String ZK_SASL_CLIENT_USERNAME_DEFAULT = "zookeeper";
    public static final String ZK_SASL_CLIENT_CANONICALIZE_HOSTNAME = "zookeeper.sasl.client.canonicalize.hostname";
    public static final String ZK_SASL_CLIENT_CANONICALIZE_HOSTNAME_DEFAULT = "true";
    public static final String LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    public static final String LOGIN_CONTEXT_NAME_KEY_DEFAULT = "Client";
    public static final String ENABLE_CLIENT_SASL_KEY = "zookeeper.sasl.client";
    public static final String ENABLE_CLIENT_SASL_DEFAULT = "true";
    public static final String ZOOKEEPER_SERVER_REALM = "zookeeper.server.realm";
    public static final String DISABLE_AUTO_WATCH_RESET = "zookeeper.disableAutoWatchReset";
    public static final String ZOOKEEPER_CLIENT_CNXN_SOCKET = "zookeeper.clientCnxnSocket";
    public static final String SECURE_CLIENT = "zookeeper.client.secure";
    public static final int CLIENT_MAX_PACKET_LENGTH_DEFAULT = 1048575;
    public static final String ZOOKEEPER_REQUEST_TIMEOUT = "zookeeper.request.timeout";
    public static final String ZOOKEEPER_SERVER_PRINCIPAL = "zookeeper.server.principal";
    public static final long ZOOKEEPER_REQUEST_TIMEOUT_DEFAULT = 0L;

    public ZKClientConfig() {
        this.initFromJavaSystemProperties();
    }

    public ZKClientConfig(File configFile) throws QuorumPeerConfig.ConfigException {
        super(configFile);
    }

    public ZKClientConfig(String configPath) throws QuorumPeerConfig.ConfigException {
        super(configPath);
    }

    private void initFromJavaSystemProperties() {
        this.setProperty(ZOOKEEPER_REQUEST_TIMEOUT, System.getProperty(ZOOKEEPER_REQUEST_TIMEOUT));
        this.setProperty(ZOOKEEPER_SERVER_PRINCIPAL, System.getProperty(ZOOKEEPER_SERVER_PRINCIPAL));
    }

    @Override
    protected void handleBackwardCompatibility() {
        super.handleBackwardCompatibility();
        this.setProperty(ZK_SASL_CLIENT_USERNAME, System.getProperty(ZK_SASL_CLIENT_USERNAME));
        this.setProperty(ZK_SASL_CLIENT_CANONICALIZE_HOSTNAME, System.getProperty(ZK_SASL_CLIENT_CANONICALIZE_HOSTNAME));
        this.setProperty(LOGIN_CONTEXT_NAME_KEY, System.getProperty(LOGIN_CONTEXT_NAME_KEY));
        this.setProperty(ENABLE_CLIENT_SASL_KEY, System.getProperty(ENABLE_CLIENT_SASL_KEY));
        this.setProperty(ZOOKEEPER_SERVER_REALM, System.getProperty(ZOOKEEPER_SERVER_REALM));
        this.setProperty(DISABLE_AUTO_WATCH_RESET, System.getProperty(DISABLE_AUTO_WATCH_RESET));
        this.setProperty(ZOOKEEPER_CLIENT_CNXN_SOCKET, System.getProperty(ZOOKEEPER_CLIENT_CNXN_SOCKET));
        this.setProperty(SECURE_CLIENT, System.getProperty(SECURE_CLIENT));
    }

    public boolean isSaslClientEnabled() {
        return Boolean.valueOf(this.getProperty(ENABLE_CLIENT_SASL_KEY, "true"));
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getProperty(key);
        if (value != null) {
            return Long.parseLong(value.trim());
        }
        return defaultValue;
    }
}

