/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.com.codahale.metrics;

import java.util.Random;
import org.apache.flink.shaded.zookeeper3.com.codahale.metrics.ThreadLocalRandom;

class ThreadLocalRandomProxy {
    private static final Provider INSTANCE = ThreadLocalRandomProxy.getThreadLocalProvider();

    ThreadLocalRandomProxy() {
    }

    private static Provider getThreadLocalProvider() {
        try {
            JdkProvider jdkProvider = new JdkProvider();
            jdkProvider.current();
            return jdkProvider;
        }
        catch (Throwable e) {
            return new InternalProvider();
        }
    }

    public static Random current() {
        return INSTANCE.current();
    }

    private static class InternalProvider
    implements Provider {
        private InternalProvider() {
        }

        @Override
        public Random current() {
            return ThreadLocalRandom.current();
        }
    }

    private static class JdkProvider
    implements Provider {
        private JdkProvider() {
        }

        @Override
        public Random current() {
            return java.util.concurrent.ThreadLocalRandom.current();
        }
    }

    private static interface Provider {
        public Random current();
    }
}

