/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.FloatValueArray;
import org.apache.flink.types.NormalizableKey;

@Internal
public class FloatValueArrayComparator
extends TypeComparator<FloatValueArray> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final FloatValueArray reference = new FloatValueArray();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public FloatValueArrayComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    public int hash(FloatValueArray record) {
        return record.hashCode();
    }

    public void setReference(FloatValueArray toCompare) {
        toCompare.copyTo(this.reference);
    }

    public boolean equalToReference(FloatValueArray candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<FloatValueArray> referencedComparator) {
        int comp = ((FloatValueArrayComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(FloatValueArray first, FloatValueArray second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstCount = firstSource.readInt();
        int secondCount = secondSource.readInt();
        int minCount = Math.min(firstCount, secondCount);
        while (minCount-- > 0) {
            float secondValue;
            float firstValue = firstSource.readFloat();
            int cmp = Float.compare(firstValue, secondValue = secondSource.readFloat());
            if (cmp == 0) continue;
            return this.ascendingComparison ? cmp : -cmp;
        }
        int cmp = Integer.compare(firstCount, secondCount);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(FloatValueArray.class);
    }

    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyFloats) {
        return keyFloats < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(FloatValueArray record, MemorySegment target, int offset, int numFloats) {
        record.copyNormalizedKey(target, offset, numFloats);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<FloatValueArray> duplicate() {
        return new FloatValueArrayComparator(this.ascendingComparison);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(FloatValueArray record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FloatValueArray readWithKeyDenormalization(FloatValueArray reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

