/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.ByteValueArray;
import org.apache.flink.types.NormalizableKey;

@Internal
public class ByteValueArrayComparator
extends TypeComparator<ByteValueArray> {
    private static final long serialVersionUID = 1L;
    private final boolean ascendingComparison;
    private final ByteValueArray reference = new ByteValueArray();
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public ByteValueArrayComparator(boolean ascending) {
        this.ascendingComparison = ascending;
    }

    public int hash(ByteValueArray record) {
        return record.hashCode();
    }

    public void setReference(ByteValueArray toCompare) {
        toCompare.copyTo(this.reference);
    }

    public boolean equalToReference(ByteValueArray candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<ByteValueArray> referencedComparator) {
        int comp = ((ByteValueArrayComparator)referencedComparator).reference.compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(ByteValueArray first, ByteValueArray second) {
        int comp = first.compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int firstCount = firstSource.readInt();
        int secondCount = secondSource.readInt();
        int minCount = Math.min(firstCount, secondCount);
        while (minCount-- > 0) {
            byte secondValue;
            byte firstValue = firstSource.readByte();
            int cmp = Byte.compare(firstValue, secondValue = secondSource.readByte());
            if (cmp == 0) continue;
            return this.ascendingComparison ? cmp : -cmp;
        }
        int cmp = Integer.compare(firstCount, secondCount);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(ByteValueArray.class);
    }

    public int getNormalizeKeyLen() {
        return this.reference.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(ByteValueArray record, MemorySegment target, int offset, int numBytes) {
        record.copyNormalizedKey(target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<ByteValueArray> duplicate() {
        return new ByteValueArrayComparator(this.ascendingComparison);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(ByteValueArray record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteValueArray readWithKeyDenormalization(ByteValueArray reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }
}

