/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.spargel;

import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.spargel.MessageIterator;
import org.apache.flink.types.Value;
import org.apache.flink.util.Collector;

public abstract class GatherFunction<K, VV, Message>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long numberOfVertices = -1L;
    private boolean optDegrees;
    private IterationRuntimeContext runtimeContext;
    private Collector<Vertex<K, VV>> out;
    private Collector<Vertex<K, Tuple3<VV, Long, Long>>> outWithDegrees;
    private Vertex<K, VV> outVal;
    private Vertex<K, Tuple3<VV, Long, Long>> outValWithDegrees;
    private long inDegree = -1L;
    private long outDegree = -1L;
    private boolean setNewVertexValueCalled;

    public long getNumberOfVertices() {
        return this.numberOfVertices;
    }

    void setNumberOfVertices(long numberOfVertices) {
        this.numberOfVertices = numberOfVertices;
    }

    boolean isOptDegrees() {
        return this.optDegrees;
    }

    void setOptDegrees(boolean optDegrees) {
        this.optDegrees = optDegrees;
    }

    public abstract void updateVertex(Vertex<K, VV> var1, MessageIterator<Message> var2) throws Exception;

    public void preSuperstep() throws Exception {
    }

    public void postSuperstep() throws Exception {
    }

    public void setNewVertexValue(VV newValue) {
        if (this.setNewVertexValueCalled) {
            throw new IllegalStateException("setNewVertexValue should only be called at most once per updateVertex");
        }
        this.setNewVertexValueCalled = true;
        if (this.isOptDegrees()) {
            ((Tuple3)this.outValWithDegrees.f1).f0 = newValue;
            this.outWithDegrees.collect(this.outValWithDegrees);
        } else {
            this.outVal.setValue(newValue);
            this.out.collect(this.outVal);
        }
    }

    public int getSuperstepNumber() {
        return this.runtimeContext.getSuperstepNumber();
    }

    public <T extends Aggregator<?>> T getIterationAggregator(String name) {
        return (T)this.runtimeContext.getIterationAggregator(name);
    }

    public <T extends Value> T getPreviousIterationAggregate(String name) {
        return (T)this.runtimeContext.getPreviousIterationAggregate(name);
    }

    public <T> Collection<T> getBroadcastSet(String name) {
        return this.runtimeContext.getBroadcastVariable(name);
    }

    void init(IterationRuntimeContext context) {
        this.runtimeContext = context;
    }

    void setOutput(Vertex<K, VV> outVal, Collector<Vertex<K, VV>> out) {
        this.outVal = outVal;
        this.out = out;
        this.setNewVertexValueCalled = false;
    }

    <ValueWithDegree> void setOutputWithDegrees(Vertex<K, ValueWithDegree> outVal, Collector out) {
        this.outValWithDegrees = outVal;
        this.outWithDegrees = out;
        this.setNewVertexValueCalled = false;
    }

    public long getInDegree() {
        return this.inDegree;
    }

    void setInDegree(long inDegree) {
        this.inDegree = inDegree;
    }

    public long getOutDegree() {
        return this.outDegree;
    }

    void setOutDegree(long outDegree) {
        this.outDegree = outDegree;
    }

    <VertexWithDegree> void updateVertexFromScatterGatherIteration(Vertex<K, VertexWithDegree> vertexState, MessageIterator<Message> inMessages) throws Exception {
        Vertex<Object, Object> vertex = new Vertex<Object, Object>(vertexState.f0, ((Tuple3)vertexState.getValue()).f0);
        this.updateVertex(vertex, inMessages);
    }
}

