/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.pregel;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.RichCoGroupFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.CustomUnaryOperation;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.graph.Edge;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.pregel.ComputeFunction;
import org.apache.flink.graph.pregel.MessageCombiner;
import org.apache.flink.graph.pregel.MessageIterator;
import org.apache.flink.graph.pregel.VertexCentricConfiguration;
import org.apache.flink.types.Either;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class VertexCentricIteration<K, VV, EV, Message>
implements CustomUnaryOperation<Vertex<K, VV>, Vertex<K, VV>> {
    private final ComputeFunction<K, VV, EV, Message> computeFunction;
    private final MessageCombiner<K, Message> combineFunction;
    private final DataSet<Edge<K, EV>> edgesWithValue;
    private final int maximumNumberOfIterations;
    private final TypeInformation<Message> messageType;
    private DataSet<Vertex<K, VV>> initialVertices;
    private VertexCentricConfiguration configuration;

    private VertexCentricIteration(ComputeFunction<K, VV, EV, Message> cf, DataSet<Edge<K, EV>> edgesWithValue, MessageCombiner<K, Message> mc, int maximumNumberOfIterations) {
        Preconditions.checkNotNull(cf);
        Preconditions.checkNotNull(edgesWithValue);
        Preconditions.checkArgument((maximumNumberOfIterations > 0 ? 1 : 0) != 0, (Object)"The maximum number of iterations must be at least one.");
        this.computeFunction = cf;
        this.edgesWithValue = edgesWithValue;
        this.combineFunction = mc;
        this.maximumNumberOfIterations = maximumNumberOfIterations;
        this.messageType = this.getMessageType(cf);
    }

    private TypeInformation<Message> getMessageType(ComputeFunction<K, VV, EV, Message> cf) {
        return TypeExtractor.createTypeInfo(cf, ComputeFunction.class, cf.getClass(), (int)3);
    }

    public void setInput(DataSet<Vertex<K, VV>> inputData) {
        this.initialVertices = inputData;
    }

    public DataSet<Vertex<K, VV>> createResult() {
        SingleInputUdfOperator allMessages;
        if (this.initialVertices == null) {
            throw new IllegalStateException("The input data set has not been set.");
        }
        TypeInformation keyType = ((TupleTypeInfo)this.initialVertices.getType()).getTypeAt(0);
        TupleTypeInfo messageTypeInfo = new TupleTypeInfo(new TypeInformation[]{keyType, this.messageType});
        TypeInformation vertexType = this.initialVertices.getType();
        EitherTypeInfo intermediateTypeInfo = new EitherTypeInfo(vertexType, (TypeInformation)messageTypeInfo);
        EitherTypeInfo nullableMsgTypeInfo = new EitherTypeInfo(TypeExtractor.getForClass(NullValue.class), this.messageType);
        TupleTypeInfo workSetTypeInfo = new TupleTypeInfo(new TypeInformation[]{keyType, nullableMsgTypeInfo});
        SingleInputUdfOperator initialWorkSet = this.initialVertices.map(new InitializeWorkSet()).returns((TypeInformation)workSetTypeInfo);
        DeltaIteration iteration = this.initialVertices.iterateDelta((DataSet)initialWorkSet, this.maximumNumberOfIterations, new int[]{0});
        this.setUpIteration(iteration);
        TwoInputUdfOperator verticesWithMsgs = iteration.getSolutionSet().join((DataSet)iteration.getWorkset()).where(new int[]{0}).equalTo(new int[]{0}).with(new AppendVertexState()).returns((TypeInformation)new TupleTypeInfo(new TypeInformation[]{vertexType, nullableMsgTypeInfo}));
        VertexComputeUdf vertexUdf = new VertexComputeUdf(this.computeFunction, (TypeInformation)intermediateTypeInfo);
        CoGroupOperator superstepComputation = verticesWithMsgs.coGroup(this.edgesWithValue).where(new String[]{"f0.f0"}).equalTo(new int[]{0}).with(vertexUdf);
        SingleInputUdfOperator solutionSetDelta = superstepComputation.flatMap(new ProjectNewVertexValue()).returns(vertexType);
        SingleInputUdfOperator newWorkSet = allMessages = superstepComputation.flatMap(new ProjectMessages()).returns((TypeInformation)workSetTypeInfo);
        if (this.combineFunction != null) {
            MessageCombinerUdf combinerUdf = new MessageCombinerUdf(this.combineFunction, (TypeInformation)workSetTypeInfo);
            GroupReduceOperator combinedMessages = allMessages.groupBy(new int[]{0}).reduceGroup(combinerUdf).setCombinable(true);
            newWorkSet = combinedMessages;
        }
        superstepComputation = (CoGroupOperator)superstepComputation.name("Compute Function");
        if (this.configuration != null) {
            for (Tuple2<String, DataSet<?>> e : this.configuration.getBcastVars()) {
                superstepComputation = (CoGroupOperator)superstepComputation.withBroadcastSet((DataSet)e.f1, (String)e.f0);
            }
        }
        return iteration.closeWith((DataSet)solutionSetDelta, (DataSet)newWorkSet);
    }

    public static <K, VV, EV, Message> VertexCentricIteration<K, VV, EV, Message> withEdges(DataSet<Edge<K, EV>> edgesWithValue, ComputeFunction<K, VV, EV, Message> cf, int maximumNumberOfIterations) {
        return new VertexCentricIteration<K, VV, EV, Message>(cf, edgesWithValue, null, maximumNumberOfIterations);
    }

    public static <K, VV, EV, Message> VertexCentricIteration<K, VV, EV, Message> withEdges(DataSet<Edge<K, EV>> edgesWithValue, ComputeFunction<K, VV, EV, Message> cf, MessageCombiner<K, Message> mc, int maximumNumberOfIterations) {
        return new VertexCentricIteration<K, VV, EV, Message>(cf, edgesWithValue, mc, maximumNumberOfIterations);
    }

    public void configure(VertexCentricConfiguration parameters) {
        this.configuration = parameters;
    }

    public VertexCentricConfiguration getIterationConfiguration() {
        return this.configuration;
    }

    private void setUpIteration(DeltaIteration<?, ?> iteration) {
        if (this.configuration != null) {
            iteration.name(this.configuration.getName("Vertex-centric iteration (" + this.computeFunction + ")"));
            iteration.parallelism(this.configuration.getParallelism());
            iteration.setSolutionSetUnManaged(this.configuration.isSolutionSetUnmanagedMemory());
            for (Map.Entry<String, Aggregator<?>> entry : this.configuration.getAggregators().entrySet()) {
                iteration.registerAggregator(entry.getKey(), entry.getValue());
            }
        } else {
            iteration.name("Vertex-centric iteration (" + this.computeFunction + ")");
        }
    }

    private static final class ProjectMessages<K, VV, Message>
    implements FlatMapFunction<Either<Vertex<K, VV>, Tuple2<K, Message>>, Tuple2<K, Either<NullValue, Message>>> {
        private Tuple2<K, Either<NullValue, Message>> outTuple = new Tuple2();

        private ProjectMessages() {
        }

        public void flatMap(Either<Vertex<K, VV>, Tuple2<K, Message>> value, Collector<Tuple2<K, Either<NullValue, Message>>> out) {
            if (value.isRight()) {
                Tuple2 message = (Tuple2)value.right();
                this.outTuple.f0 = message.f0;
                this.outTuple.f1 = Either.Right((Object)message.f1);
                out.collect(this.outTuple);
            }
        }
    }

    private static final class ProjectNewVertexValue<K, VV, Message>
    implements FlatMapFunction<Either<Vertex<K, VV>, Tuple2<K, Message>>, Vertex<K, VV>> {
        private ProjectNewVertexValue() {
        }

        public void flatMap(Either<Vertex<K, VV>, Tuple2<K, Message>> value, Collector<Vertex<K, VV>> out) {
            if (value.isLeft()) {
                out.collect(value.left());
            }
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"*->f0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"f1->f1"})
    private static final class AppendVertexState<K, VV, Message>
    implements JoinFunction<Vertex<K, VV>, Tuple2<K, Either<NullValue, Message>>, Tuple2<Vertex<K, VV>, Either<NullValue, Message>>> {
        private Tuple2<Vertex<K, VV>, Either<NullValue, Message>> outTuple = new Tuple2();

        private AppendVertexState() {
        }

        public Tuple2<Vertex<K, VV>, Either<NullValue, Message>> join(Vertex<K, VV> vertex, Tuple2<K, Either<NullValue, Message>> message) {
            this.outTuple.f0 = vertex;
            this.outTuple.f1 = message.f1;
            return this.outTuple;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"f0"})
    private static class MessageCombinerUdf<K, Message>
    extends RichGroupReduceFunction<Tuple2<K, Either<NullValue, Message>>, Tuple2<K, Either<NullValue, Message>>>
    implements ResultTypeQueryable<Tuple2<K, Either<NullValue, Message>>>,
    GroupCombineFunction<Tuple2<K, Either<NullValue, Message>>, Tuple2<K, Either<NullValue, Message>>> {
        final MessageCombiner<K, Message> combinerFunction;
        private transient TypeInformation<Tuple2<K, Either<NullValue, Message>>> resultType;

        private MessageCombinerUdf(MessageCombiner<K, Message> combineFunction, TypeInformation<Tuple2<K, Either<NullValue, Message>>> messageTypeInfo) {
            this.combinerFunction = combineFunction;
            this.resultType = messageTypeInfo;
        }

        public TypeInformation<Tuple2<K, Either<NullValue, Message>>> getProducedType() {
            return this.resultType;
        }

        public void reduce(Iterable<Tuple2<K, Either<NullValue, Message>>> messages, Collector<Tuple2<K, Either<NullValue, Message>>> out) throws Exception {
            Iterator messageIterator = messages.iterator();
            if (messageIterator.hasNext()) {
                Tuple2<K, Either<NullValue, Message>> first = messageIterator.next();
                Object vertexID = first.f0;
                MessageIterator<Object> messageIter = new MessageIterator<Object>();
                messageIter.setFirst(((Either)first.f1).right());
                Iterator downcastIter = messageIterator;
                messageIter.setSource(downcastIter);
                this.combinerFunction.set(vertexID, out);
                this.combinerFunction.combineMessages(messageIter);
            }
        }

        public void combine(Iterable<Tuple2<K, Either<NullValue, Message>>> values, Collector<Tuple2<K, Either<NullValue, Message>>> out) throws Exception {
            this.reduce(values, out);
        }
    }

    private static class VertexComputeUdf<K, VV, EV, Message>
    extends RichCoGroupFunction<Tuple2<Vertex<K, VV>, Either<NullValue, Message>>, Edge<K, EV>, Either<Vertex<K, VV>, Tuple2<K, Message>>>
    implements ResultTypeQueryable<Either<Vertex<K, VV>, Tuple2<K, Message>>> {
        final ComputeFunction<K, VV, EV, Message> computeFunction;
        private transient TypeInformation<Either<Vertex<K, VV>, Tuple2<K, Message>>> resultType;

        private VertexComputeUdf(ComputeFunction<K, VV, EV, Message> compute, TypeInformation<Either<Vertex<K, VV>, Tuple2<K, Message>>> typeInfo) {
            this.computeFunction = compute;
            this.resultType = typeInfo;
        }

        public TypeInformation<Either<Vertex<K, VV>, Tuple2<K, Message>>> getProducedType() {
            return this.resultType;
        }

        public void open(Configuration parameters) throws Exception {
            if (this.getIterationRuntimeContext().getSuperstepNumber() == 1) {
                this.computeFunction.init(this.getIterationRuntimeContext());
            }
            this.computeFunction.preSuperstep();
        }

        public void close() throws Exception {
            this.computeFunction.postSuperstep();
        }

        public void coGroup(Iterable<Tuple2<Vertex<K, VV>, Either<NullValue, Message>>> messages, Iterable<Edge<K, EV>> edgesIterator, Collector<Either<Vertex<K, VV>, Tuple2<K, Message>>> out) throws Exception {
            Iterator vertexIter = messages.iterator();
            if (vertexIter.hasNext()) {
                Tuple2<Vertex<K, VV>, Either<NullValue, Message>> first = vertexIter.next();
                Vertex vertexState = (Vertex)((Object)first.f0);
                MessageIterator<Object> messageIter = new MessageIterator<Object>();
                if (this.getIterationRuntimeContext().getSuperstepNumber() != 1) {
                    messageIter.setFirst(((Either)first.f1).right());
                    Iterator downcastIter = vertexIter;
                    messageIter.setSource(downcastIter);
                }
                this.computeFunction.set(vertexState.getId(), edgesIterator.iterator(), out);
                this.computeFunction.compute(vertexState, messageIter);
            }
        }
    }

    private static class InitializeWorkSet<K, VV, Message>
    extends RichMapFunction<Vertex<K, VV>, Tuple2<K, Either<NullValue, Message>>> {
        private Tuple2<K, Either<NullValue, Message>> outTuple;
        private Either<NullValue, Message> nullMessage;

        private InitializeWorkSet() {
        }

        public void open(Configuration parameters) {
            this.outTuple = new Tuple2();
            this.nullMessage = Either.Left((Object)NullValue.getInstance());
            this.outTuple.f1 = this.nullMessage;
        }

        public Tuple2<K, Either<NullValue, Message>> map(Vertex<K, VV> vertex) {
            this.outTuple.f0 = vertex.getId();
            return this.outTuple;
        }
    }
}

