/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.undirected;

import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.common.accumulators.DoubleCounter;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.AnalyticHelper;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAnalyticBase;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.library.clustering.undirected.LocalClusteringCoefficient;
import org.apache.flink.types.CopyableValue;

public class AverageClusteringCoefficient<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAnalyticBase<K, VV, EV, Result> {
    private static final String VERTEX_COUNT = "vertexCount";
    private static final String SUM_OF_LOCAL_CLUSTERING_COEFFICIENT = "sumOfLocalClusteringCoefficient";
    private AverageClusteringCoefficientHelper<K> averageClusteringCoefficientHelper;

    public AverageClusteringCoefficient<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        DataSet localClusteringCoefficient = (DataSet)input.run(new LocalClusteringCoefficient().setParallelism(this.parallelism));
        this.averageClusteringCoefficientHelper = new AverageClusteringCoefficientHelper();
        localClusteringCoefficient.output(this.averageClusteringCoefficientHelper).name("Average clustering coefficient");
        return this;
    }

    @Override
    public Result getResult() {
        long vertexCount = (Long)this.averageClusteringCoefficientHelper.getAccumulator(this.env, VERTEX_COUNT);
        double sumOfLocalClusteringCoefficient = (Double)this.averageClusteringCoefficientHelper.getAccumulator(this.env, SUM_OF_LOCAL_CLUSTERING_COEFFICIENT);
        return new Result(vertexCount, sumOfLocalClusteringCoefficient);
    }

    public static class Result
    implements PrintableResult {
        private long vertexCount;
        private double averageLocalClusteringCoefficient;

        public Result(long vertexCount, double sumOfLocalClusteringCoefficient) {
            this.vertexCount = vertexCount;
            this.averageLocalClusteringCoefficient = sumOfLocalClusteringCoefficient / (double)vertexCount;
        }

        public long getNumberOfVertices() {
            return this.vertexCount;
        }

        public double getAverageClusteringCoefficient() {
            return this.averageLocalClusteringCoefficient;
        }

        public String toString() {
            return this.toPrintableString();
        }

        @Override
        public String toPrintableString() {
            return "vertex count: " + this.vertexCount + ", average clustering coefficient: " + this.averageLocalClusteringCoefficient;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.vertexCount).append(this.averageLocalClusteringCoefficient).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Result rhs = (Result)obj;
            return new EqualsBuilder().append(this.vertexCount, rhs.vertexCount).append(this.averageLocalClusteringCoefficient, rhs.averageLocalClusteringCoefficient).isEquals();
        }
    }

    private static class AverageClusteringCoefficientHelper<T>
    extends AnalyticHelper<LocalClusteringCoefficient.Result<T>> {
        private long vertexCount;
        private double sumOfLocalClusteringCoefficient;

        private AverageClusteringCoefficientHelper() {
        }

        public void writeRecord(LocalClusteringCoefficient.Result<T> record) throws IOException {
            ++this.vertexCount;
            if (record.getDegree().getValue() > 1L) {
                this.sumOfLocalClusteringCoefficient += record.getLocalClusteringCoefficientScore();
            }
        }

        public void close() throws IOException {
            this.addAccumulator(AverageClusteringCoefficient.VERTEX_COUNT, new LongCounter(this.vertexCount));
            this.addAccumulator(AverageClusteringCoefficient.SUM_OF_LOCAL_CLUSTERING_COEFFICIENT, new DoubleCounter(this.sumOfLocalClusteringCoefficient));
        }
    }
}

