/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.generator.CirculantGraph;
import org.apache.flink.graph.generator.GraphGeneratorBase;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Preconditions;

public class CompleteGraph
extends GraphGeneratorBase<LongValue, NullValue, NullValue> {
    public static final int MINIMUM_VERTEX_COUNT = 2;
    private final ExecutionEnvironment env;
    private final long vertexCount;

    public CompleteGraph(ExecutionEnvironment env, long vertexCount) {
        Preconditions.checkArgument((vertexCount >= 2L ? 1 : 0) != 0, (Object)"Vertex count must be at least 2");
        this.env = env;
        this.vertexCount = vertexCount;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        return new CirculantGraph(this.env, this.vertexCount).addRange(1L, this.vertexCount - 1L).setParallelism(this.parallelism).generate();
    }
}

