/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.utils.proxy;

import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.util.Preconditions;

public abstract class GraphAlgorithmWrappingBase<K, VV, EV, R>
implements GraphAlgorithm<K, VV, EV, R> {
    protected int parallelism = -1;

    public GraphAlgorithmWrappingBase<K, VV, EV, R> setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be at least one, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
        this.parallelism = parallelism;
        return this;
    }

    public String getAlgorithmName() {
        return this.getClass().getName();
    }

    protected boolean canMergeConfigurationWith(GraphAlgorithmWrappingBase other) {
        Preconditions.checkNotNull((Object)other);
        return this.getClass().equals(other.getClass());
    }

    protected void mergeConfiguration(GraphAlgorithmWrappingBase other) {
        Preconditions.checkNotNull((Object)other);
        this.parallelism = this.parallelism == -1 ? other.parallelism : (other.parallelism == -1 ? this.parallelism : Math.min(this.parallelism, other.parallelism));
    }
}

