/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.library.clustering.directed;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAnalytic;
import org.apache.flink.graph.GraphAnalyticBase;
import org.apache.flink.graph.asm.dataset.Count;
import org.apache.flink.graph.asm.result.PrintableResult;
import org.apache.flink.graph.library.clustering.directed.TriangleListing;
import org.apache.flink.graph.library.metric.directed.VertexMetrics;
import org.apache.flink.types.CopyableValue;

public class GlobalClusteringCoefficient<K extends Comparable<K> & CopyableValue<K>, VV, EV>
extends GraphAnalyticBase<K, VV, EV, Result> {
    private Count<TriangleListing.Result<K>> triangleCount;
    private GraphAnalytic<K, VV, EV, VertexMetrics.Result> vertexMetrics;

    public GlobalClusteringCoefficient<K, VV, EV> run(Graph<K, VV, EV> input) throws Exception {
        super.run(input);
        this.triangleCount = new Count();
        DataSet triangles = (DataSet)input.run(new TriangleListing().setSortTriangleVertices(false).setParallelism(this.parallelism));
        this.triangleCount.run(triangles);
        this.vertexMetrics = new VertexMetrics().setParallelism(this.parallelism);
        input.run(this.vertexMetrics);
        return this;
    }

    @Override
    public Result getResult() {
        long numberOfTriangles = 3L * this.triangleCount.getResult();
        return new Result(this.vertexMetrics.getResult().getNumberOfTriplets(), numberOfTriangles);
    }

    public static class Result
    implements PrintableResult {
        private long tripletCount;
        private long triangleCount;

        public Result(long tripletCount, long triangleCount) {
            this.tripletCount = tripletCount;
            this.triangleCount = triangleCount;
        }

        public long getNumberOfTriplets() {
            return this.tripletCount;
        }

        public long getNumberOfTriangles() {
            return this.triangleCount;
        }

        public double getGlobalClusteringCoefficientScore() {
            return this.tripletCount == 0L ? Double.NaN : (double)this.triangleCount / (double)this.tripletCount;
        }

        public String toString() {
            return this.toPrintableString();
        }

        @Override
        public String toPrintableString() {
            return "triplet count: " + this.tripletCount + ", triangle count: " + this.triangleCount + ", global clustering coefficient: " + this.getGlobalClusteringCoefficientScore();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.tripletCount).append(this.triangleCount).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Result rhs = (Result)obj;
            return new EqualsBuilder().append(this.tripletCount, rhs.tripletCount).append(this.triangleCount, rhs.triangleCount).isEquals();
        }
    }
}

