/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.asm.translate;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.asm.translate.Translate;
import org.apache.flink.graph.asm.translate.TranslateFunction;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingBase;
import org.apache.flink.graph.utils.proxy.GraphAlgorithmWrappingGraph;
import org.apache.flink.util.Preconditions;

public class TranslateVertexValues<K, OLD, NEW, EV>
extends GraphAlgorithmWrappingGraph<K, OLD, EV, K, NEW, EV> {
    private TranslateFunction<OLD, NEW> translator;

    public TranslateVertexValues(TranslateFunction<OLD, NEW> translator) {
        Preconditions.checkNotNull(translator);
        this.translator = translator;
    }

    @Override
    protected boolean canMergeConfigurationWith(GraphAlgorithmWrappingBase other) {
        if (!super.canMergeConfigurationWith(other)) {
            return false;
        }
        TranslateVertexValues rhs = (TranslateVertexValues)other;
        return this.translator == rhs.translator;
    }

    @Override
    public Graph<K, NEW, EV> runInternal(Graph<K, OLD, EV> input) throws Exception {
        DataSet<Vertex<K, NEW>> translatedVertices = Translate.translateVertexValues(input.getVertices(), this.translator, this.parallelism);
        return Graph.fromDataSet(translatedVertices, input.getEdges(), input.getContext());
    }
}

