/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Token<T extends TokenIdentifier>
implements Writable {
    public static final Logger LOG = LoggerFactory.getLogger(Token.class);
    private static Map<Text, Class<? extends TokenIdentifier>> tokenKindMap;
    private byte[] identifier;
    private byte[] password;
    private Text kind;
    private Text service;
    private TokenRenewer renewer;
    private static ServiceLoader<TokenRenewer> renewers;
    private static final TokenRenewer TRIVIAL_RENEWER;

    public Token(T id, SecretManager<T> mgr) {
        this.password = mgr.createPassword(id);
        this.identifier = ((TokenIdentifier)id).getBytes();
        this.kind = ((TokenIdentifier)id).getKind();
        this.service = new Text();
    }

    public void setID(byte[] bytes) {
        this.identifier = bytes;
    }

    public void setPassword(byte[] newPassword) {
        this.password = newPassword;
    }

    public Token(byte[] identifier, byte[] password, Text kind, Text service) {
        this.identifier = identifier == null ? new byte[]{} : identifier;
        this.password = password == null ? new byte[]{} : password;
        this.kind = kind == null ? new Text() : kind;
        this.service = service == null ? new Text() : service;
    }

    public Token() {
        this.identifier = new byte[0];
        this.password = new byte[0];
        this.kind = new Text();
        this.service = new Text();
    }

    public Token(Token<T> other) {
        this.identifier = (byte[])other.identifier.clone();
        this.password = (byte[])other.password.clone();
        this.kind = new Text(other.kind);
        this.service = new Text(other.service);
    }

    public Token<T> copyToken() {
        return new Token<T>(this);
    }

    public Token(SecurityProtos.TokenProto tokenPB) {
        this.identifier = tokenPB.getIdentifier().toByteArray();
        this.password = tokenPB.getPassword().toByteArray();
        this.kind = new Text(tokenPB.getKindBytes().toByteArray());
        this.service = new Text(tokenPB.getServiceBytes().toByteArray());
    }

    public SecurityProtos.TokenProto toTokenProto() {
        return SecurityProtos.TokenProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])this.getIdentifier())).setPassword(ByteString.copyFrom((byte[])this.getPassword())).setKindBytes(ByteString.copyFrom((byte[])this.getKind().getBytes(), (int)0, (int)this.getKind().getLength())).setServiceBytes(ByteString.copyFrom((byte[])this.getService().getBytes(), (int)0, (int)this.getService().getLength())).build();
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<? extends TokenIdentifier> getClassForIdentifier(Text kind) {
        Class<? extends TokenIdentifier> cls = null;
        Class<Token> clazz = Token.class;
        synchronized (Token.class) {
            if (tokenKindMap == null) {
                tokenKindMap = Maps.newHashMap();
                Iterator<TokenIdentifier> tokenIdentifiers = ServiceLoader.load(TokenIdentifier.class).iterator();
                while (tokenIdentifiers.hasNext()) {
                    try {
                        TokenIdentifier id = tokenIdentifiers.next();
                        tokenKindMap.put(id.getKind(), id.getClass());
                    }
                    catch (LinkageError | ServiceConfigurationError e) {
                        LOG.debug("Failed to load token identifier implementation", (Throwable)e);
                    }
                }
            }
            cls = tokenKindMap.get(kind);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (cls == null) {
                LOG.debug("Cannot find class for token kind {}", (Object)kind);
                return null;
            }
            return cls;
        }
    }

    public T decodeIdentifier() throws IOException {
        Class<TokenIdentifier> cls = Token.getClassForIdentifier(this.getKind());
        if (cls == null) {
            return null;
        }
        TokenIdentifier tokenIdentifier = ReflectionUtils.newInstance(cls, null);
        ByteArrayInputStream buf = new ByteArrayInputStream(this.identifier);
        DataInputStream in = new DataInputStream(buf);
        tokenIdentifier.readFields(in);
        in.close();
        return (T)tokenIdentifier;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public synchronized Text getKind() {
        return this.kind;
    }

    @InterfaceAudience.Private
    public synchronized void setKind(Text newKind) {
        this.kind = newKind;
        this.renewer = null;
    }

    public Text getService() {
        return this.service;
    }

    public void setService(Text newService) {
        this.service = newService;
    }

    public boolean isPrivate() {
        return false;
    }

    public boolean isPrivateCloneOf(Text thePublicService) {
        return false;
    }

    public Token<T> privateClone(Text newService) {
        return new PrivateToken(this, newService);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int len = WritableUtils.readVInt(in);
        if (this.identifier == null || this.identifier.length != len) {
            this.identifier = new byte[len];
        }
        in.readFully(this.identifier);
        len = WritableUtils.readVInt(in);
        if (this.password == null || this.password.length != len) {
            this.password = new byte[len];
        }
        in.readFully(this.password);
        this.kind.readFields(in);
        this.service.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.identifier.length);
        out.write(this.identifier);
        WritableUtils.writeVInt(out, this.password.length);
        out.write(this.password);
        this.kind.write(out);
        this.service.write(out);
    }

    private static String encodeWritable(Writable obj) throws IOException {
        DataOutputBuffer buf = new DataOutputBuffer();
        obj.write(buf);
        Base64 encoder = new Base64(0, null, true);
        byte[] raw = new byte[buf.getLength()];
        System.arraycopy(buf.getData(), 0, raw, 0, buf.getLength());
        return encoder.encodeToString(raw);
    }

    private static void decodeWritable(Writable obj, String newValue) throws IOException {
        if (newValue == null) {
            throw new HadoopIllegalArgumentException("Invalid argument, newValue is null");
        }
        Base64 decoder = new Base64(0, null, true);
        DataInputBuffer buf = new DataInputBuffer();
        byte[] decoded = decoder.decode(newValue);
        buf.reset(decoded, decoded.length);
        obj.readFields(buf);
    }

    public String encodeToUrlString() throws IOException {
        return Token.encodeWritable(this);
    }

    public void decodeFromUrlString(String newValue) throws IOException {
        Token.decodeWritable(this, newValue);
    }

    public boolean equals(Object right) {
        if (this == right) {
            return true;
        }
        if (right == null || this.getClass() != right.getClass()) {
            return false;
        }
        Token r = (Token)right;
        return Arrays.equals(this.identifier, r.identifier) && Arrays.equals(this.password, r.password) && this.kind.equals(r.kind) && this.service.equals(r.service);
    }

    public int hashCode() {
        return WritableComparator.hashBytes(this.identifier, this.identifier.length);
    }

    private static void addBinaryBuffer(StringBuilder buffer, byte[] bytes) {
        for (int idx = 0; idx < bytes.length; ++idx) {
            String num;
            if (idx != 0) {
                buffer.append(' ');
            }
            if ((num = Integer.toHexString(0xFF & bytes[idx])).length() < 2) {
                buffer.append('0');
            }
            buffer.append(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void identifierToString(StringBuilder buffer) {
        Object id = null;
        try {
            id = this.decodeIdentifier();
        }
        catch (IOException iOException) {
        }
        finally {
            if (id != null) {
                buffer.append("(").append((Object)id).append(")");
            } else {
                Token.addBinaryBuffer(buffer, this.identifier);
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Kind: ");
        buffer.append(this.kind.toString());
        buffer.append(", Service: ");
        buffer.append(this.service.toString());
        buffer.append(", Ident: ");
        this.identifierToString(buffer);
        return buffer.toString();
    }

    public String buildCacheKey() {
        return UUID.nameUUIDFromBytes(Bytes.concat(this.kind.getBytes(), this.identifier, this.password)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TokenRenewer getRenewer() throws IOException {
        if (this.renewer != null) {
            return this.renewer;
        }
        this.renewer = TRIVIAL_RENEWER;
        ServiceLoader<TokenRenewer> serviceLoader = renewers;
        synchronized (serviceLoader) {
            Iterator<TokenRenewer> it = renewers.iterator();
            while (it.hasNext()) {
                try {
                    TokenRenewer candidate = it.next();
                    if (!candidate.handleKind(this.kind)) continue;
                    this.renewer = candidate;
                    return this.renewer;
                }
                catch (ServiceConfigurationError e) {
                    LOG.debug("Failed to load token renewer implementation", (Throwable)e);
                }
            }
        }
        LOG.warn("No TokenRenewer defined for token kind {}", (Object)this.kind);
        return this.renewer;
    }

    public boolean isManaged() throws IOException {
        return this.getRenewer().isManaged(this);
    }

    public long renew(Configuration conf) throws IOException, InterruptedException {
        return this.getRenewer().renew(this, conf);
    }

    public void cancel(Configuration conf) throws IOException, InterruptedException {
        this.getRenewer().cancel(this, conf);
    }

    static {
        renewers = ServiceLoader.load(TokenRenewer.class);
        TRIVIAL_RENEWER = new TrivialRenewer();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class TrivialRenewer
    extends TokenRenewer {
        protected Text getKind() {
            return null;
        }

        @Override
        public boolean handleKind(Text kind) {
            return kind.equals(this.getKind());
        }

        @Override
        public boolean isManaged(Token<?> token) {
            return false;
        }

        @Override
        public long renew(Token<?> token, Configuration conf) {
            throw new UnsupportedOperationException("Token renewal is not supported  for " + ((Token)token).kind + " tokens");
        }

        @Override
        public void cancel(Token<?> token, Configuration conf) throws IOException, InterruptedException {
            throw new UnsupportedOperationException("Token cancel is not supported  for " + ((Token)token).kind + " tokens");
        }
    }

    static class PrivateToken<T extends TokenIdentifier>
    extends Token<T> {
        private final Text publicService;

        PrivateToken(Token<T> publicToken, Text newService) {
            super(((Token)publicToken).identifier, ((Token)publicToken).password, ((Token)publicToken).kind, newService);
            assert (!publicToken.isPrivate());
            this.publicService = ((Token)publicToken).service;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cloned private token {} from {}", (Object)this, publicToken);
            }
        }

        @Override
        public boolean isPrivate() {
            return true;
        }

        @Override
        public boolean isPrivateCloneOf(Text thePublicService) {
            return this.publicService.equals(thePublicService);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PrivateToken that = (PrivateToken)o;
            return this.publicService.equals(that.publicService);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.publicService.hashCode();
            return result;
        }
    }
}

