/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class STSClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(STSClientFactory.class);

    public static AWSSecurityTokenServiceClientBuilder builder(Configuration conf, String bucket, AWSCredentialsProvider credentials, String stsEndpoint, String stsRegion) throws IOException {
        Preconditions.checkArgument(credentials != null, "No credentials");
        AWSSecurityTokenServiceClientBuilder builder = AWSSecurityTokenServiceClientBuilder.standard();
        ClientConfiguration awsConf = S3AUtils.createAwsConf(conf, bucket);
        builder.withClientConfiguration(awsConf);
        builder.withCredentials(credentials);
        if (StringUtils.isNotEmpty(stsEndpoint)) {
            LOG.debug("STS Endpoint ={}", (Object)stsEndpoint);
            builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(stsEndpoint, stsRegion));
        }
        return builder;
    }
}

