/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup;

import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.DateStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.EnvironmentVariableStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.InterpolatorStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.JavaPlatformStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.LocalHostStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.MapStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.NullStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.ResourceBundleStringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.StringLookup;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.text.lookup.SystemPropertyStringLookup;

public final class StringLookupFactory {
    public static final StringLookupFactory INSTANCE = new StringLookupFactory();

    private StringLookupFactory() {
    }

    public StringLookup dateStringLookup() {
        return DateStringLookup.INSTANCE;
    }

    public StringLookup environmentVariableStringLookup() {
        return EnvironmentVariableStringLookup.INSTANCE;
    }

    public StringLookup interpolatorStringLookup() {
        return new InterpolatorStringLookup();
    }

    public <V> StringLookup interpolatorStringLookup(Map<String, V> map) {
        return new InterpolatorStringLookup(map);
    }

    public StringLookup interpolatorStringLookup(StringLookup defaultStringLookup) {
        return new InterpolatorStringLookup(defaultStringLookup);
    }

    public StringLookup interpolatorStringLookup(Map<String, StringLookup> stringLookupMap, StringLookup defaultStringLookup, boolean addDefaultLookups) {
        return new InterpolatorStringLookup(stringLookupMap, defaultStringLookup, addDefaultLookups);
    }

    public StringLookup javaPlatformStringLookup() {
        return JavaPlatformStringLookup.INSTANCE;
    }

    public StringLookup localHostStringLookup() {
        return LocalHostStringLookup.INSTANCE;
    }

    public <V> StringLookup mapStringLookup(Map<String, V> map) {
        return MapStringLookup.on(map);
    }

    public StringLookup nullStringLookup() {
        return NullStringLookup.INSTANCE;
    }

    public StringLookup resourceBundleStringLookup() {
        return ResourceBundleStringLookup.INSTANCE;
    }

    public StringLookup systemPropertyStringLookup() {
        return SystemPropertyStringLookup.INSTANCE;
    }
}

