/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.DefaultCredentialsProvider;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IamUtils;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComputeEngineCredentials
extends GoogleCredentials
implements ServiceAccountSigner,
IdTokenProvider {
    static final Duration COMPUTE_EXPIRATION_MARGIN = Duration.ofMinutes(3L);
    static final Duration COMPUTE_REFRESH_MARGIN = Duration.ofMinutes(4L);
    private static final Logger LOGGER = Logger.getLogger(ComputeEngineCredentials.class.getName());
    static final String DEFAULT_METADATA_SERVER_URL = "http://metadata.google.internal";
    static final String SIGN_BLOB_URL_FORMAT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:signBlob";
    static final int MAX_COMPUTE_PING_TRIES = 3;
    static final int COMPUTE_PING_CONNECTION_TIMEOUT_MS = 500;
    private static final String METADATA_FLAVOR = "Metadata-Flavor";
    private static final String GOOGLE = "Google";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private static final String PARSE_ERROR_ACCOUNT = "Error parsing service account response. ";
    private static final long serialVersionUID = -4113476462526554235L;
    private final String transportFactoryClassName;
    private final Collection<String> scopes;
    private transient HttpTransportFactory transportFactory;
    private transient String serviceAccountEmail;

    private ComputeEngineCredentials(HttpTransportFactory transportFactory, Collection<String> scopes, Collection<String> defaultScopes) {
        super(null, COMPUTE_REFRESH_MARGIN, COMPUTE_EXPIRATION_MARGIN);
        this.transportFactory = MoreObjects.firstNonNull(transportFactory, ComputeEngineCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        if (scopes == null || scopes.isEmpty()) {
            scopes = defaultScopes;
        }
        if (scopes == null) {
            this.scopes = ImmutableSet.of();
        } else {
            ArrayList<String> scopeList = new ArrayList<String>(scopes);
            scopeList.removeAll(Arrays.asList("", null));
            this.scopes = ImmutableSet.copyOf(scopeList);
        }
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes) {
        return new ComputeEngineCredentials(this.transportFactory, newScopes, null);
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes, Collection<String> newDefaultScopes) {
        return new ComputeEngineCredentials(this.transportFactory, newScopes, newDefaultScopes);
    }

    public static ComputeEngineCredentials create() {
        return new ComputeEngineCredentials(null, null, null);
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }

    String createTokenUrlWithScopes() {
        GenericUrl tokenUrl = new GenericUrl(ComputeEngineCredentials.getTokenServerEncodedUrl());
        if (!this.scopes.isEmpty()) {
            tokenUrl.set("scopes", Joiner.on(',').join(this.scopes));
        }
        return tokenUrl.toString();
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response = this.getMetadataResponse(this.createTokenUrlWithScopes());
        int statusCode = response.getStatusCode();
        if (statusCode == 404) {
            throw new IOException(String.format("Error code %s trying to get security access token from Compute Engine metadata for the default service account. This may be because the virtual machine instance does not have permission scopes specified. It is possible to skip checking for Compute Engine metadata by specifying the environment  variable NO_GCE_CHECK=true.", statusCode));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to get security access token from Compute Engine metadata for the default service account: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from metadata token server request.");
        }
        GenericData responseData = response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)(expiresInSeconds * 1000);
        return new AccessToken(accessToken, new Date(expiresAtMilliseconds));
    }

    @Override
    public IdToken idTokenWithAudience(String targetAudience, List<IdTokenProvider.Option> options) throws IOException {
        GenericUrl documentUrl = new GenericUrl(ComputeEngineCredentials.getIdentityDocumentUrl());
        if (options != null) {
            if (options.contains((Object)IdTokenProvider.Option.FORMAT_FULL)) {
                documentUrl.set("format", "full");
            }
            if (options.contains((Object)IdTokenProvider.Option.LICENSES_TRUE)) {
                documentUrl.set("format", "full");
                documentUrl.set("license", "TRUE");
            }
        }
        documentUrl.set("audience", targetAudience);
        HttpResponse response = this.getMetadataResponse(documentUrl.toString());
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from metadata token server request.");
        }
        String rawToken = response.parseAsString();
        return IdToken.create(rawToken);
    }

    private HttpResponse getMetadataResponse(String url) throws IOException {
        HttpResponse response;
        GenericUrl genericUrl = new GenericUrl(url);
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildGetRequest(genericUrl);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser(parser);
        request.getHeaders().set(METADATA_FLAVOR, GOOGLE);
        request.setThrowExceptionOnExecuteError(false);
        try {
            response = request.execute();
        }
        catch (UnknownHostException exception) {
            throw new IOException("ComputeEngineCredentials cannot find the metadata server. This is likely because code is not running on Google Compute Engine.", exception);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean runningOnComputeEngine(HttpTransportFactory transportFactory, DefaultCredentialsProvider provider) {
        if (Boolean.parseBoolean(provider.getEnv("NO_GCE_CHECK"))) {
            return false;
        }
        GenericUrl tokenUrl = new GenericUrl(ComputeEngineCredentials.getMetadataServerUrl(provider));
        for (int i = 1; i <= 3; ++i) {
            boolean bl;
            HttpRequest request2 = transportFactory.create().createRequestFactory().buildGetRequest(tokenUrl);
            request2.setConnectTimeout(500);
            request2.getHeaders().set(METADATA_FLAVOR, GOOGLE);
            HttpResponse response = request2.execute();
            try {
                HttpHeaders headers = response.getHeaders();
                bl = OAuth2Utils.headersContainValue(headers, METADATA_FLAVOR, GOOGLE);
            }
            catch (Throwable throwable) {
                try {
                    response.disconnect();
                    throw throwable;
                }
                catch (SocketTimeoutException request2) {
                    continue;
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Encountered an unexpected exception when determining if we are running on Google Compute Engine.", e);
                }
            }
            response.disconnect();
            return bl;
        }
        LOGGER.log(Level.FINE, "Failed to detect whether we are running on Google Compute Engine.");
        return false;
    }

    public static String getMetadataServerUrl(DefaultCredentialsProvider provider) {
        String metadataServerAddress = provider.getEnv("GCE_METADATA_HOST");
        if (metadataServerAddress != null) {
            return "http://" + metadataServerAddress;
        }
        return DEFAULT_METADATA_SERVER_URL;
    }

    public static String getMetadataServerUrl() {
        return ComputeEngineCredentials.getMetadataServerUrl(DefaultCredentialsProvider.DEFAULT);
    }

    public static String getTokenServerEncodedUrl(DefaultCredentialsProvider provider) {
        return ComputeEngineCredentials.getMetadataServerUrl(provider) + "/computeMetadata/v1/instance/service-accounts/default/token";
    }

    public static String getTokenServerEncodedUrl() {
        return ComputeEngineCredentials.getTokenServerEncodedUrl(DefaultCredentialsProvider.DEFAULT);
    }

    public static String getServiceAccountsUrl() {
        return ComputeEngineCredentials.getMetadataServerUrl(DefaultCredentialsProvider.DEFAULT) + "/computeMetadata/v1/instance/service-accounts/?recursive=true";
    }

    public static String getIdentityDocumentUrl() {
        return ComputeEngineCredentials.getMetadataServerUrl(DefaultCredentialsProvider.DEFAULT) + "/computeMetadata/v1/instance/service-accounts/default/identity";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.transportFactoryClassName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("transportFactoryClassName", this.transportFactoryClassName).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ComputeEngineCredentials)) {
            return false;
        }
        ComputeEngineCredentials other = (ComputeEngineCredentials)obj;
        return Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName) && Objects.equals(this.scopes, other.scopes);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)ComputeEngineCredentials.newInstance(this.transportFactoryClassName);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getAccount() {
        if (this.serviceAccountEmail == null) {
            try {
                this.serviceAccountEmail = this.getDefaultServiceAccount();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to get service account", ex);
            }
        }
        return this.serviceAccountEmail;
    }

    @Override
    public byte[] sign(byte[] toSign) {
        try {
            String account = this.getAccount();
            return IamUtils.sign(account, this, this.transportFactory.create(), toSign, Collections.emptyMap());
        }
        catch (ServiceAccountSigner.SigningException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new ServiceAccountSigner.SigningException("Signing failed", ex);
        }
    }

    private String getDefaultServiceAccount() throws IOException {
        HttpResponse response = this.getMetadataResponse(ComputeEngineCredentials.getServiceAccountsUrl());
        int statusCode = response.getStatusCode();
        if (statusCode == 404) {
            throw new IOException(String.format("Error code %s trying to get service accounts from Compute Engine metadata. This may be because the virtual machine instance does not have permission scopes specified.", statusCode));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to get service accounts from Compute Engine metadata: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from metadata token server request.");
        }
        GenericData responseData = response.parseAs(GenericData.class);
        Map<String, Object> defaultAccount = OAuth2Utils.validateMap(responseData, "default", PARSE_ERROR_ACCOUNT);
        return OAuth2Utils.validateString(defaultAccount, "email", PARSE_ERROR_ACCOUNT);
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private HttpTransportFactory transportFactory;
        private Collection<String> scopes;

        protected Builder() {
        }

        protected Builder(ComputeEngineCredentials credentials) {
            this.transportFactory = credentials.transportFactory;
            this.scopes = credentials.scopes;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        public Collection<String> getScopes() {
            return this.scopes;
        }

        @Override
        public ComputeEngineCredentials build() {
            return new ComputeEngineCredentials(this.transportFactory, this.scopes, null);
        }
    }
}

