/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.AutoValue_ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.RestSerializationException;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.protobuf.TypeRegistry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

@AutoValue
public abstract class ApiMessageHttpResponseParser<ResponseT extends ApiMessage>
implements HttpResponseParser<ResponseT> {
    public abstract ResponseT getResponseInstance();

    protected abstract Gson getResponseMarshaller();

    private static <ResponseT extends ApiMessage> ApiMessageHttpResponseParser<ResponseT> create(final ResponseT responseInstance) {
        final Gson baseGson = new GsonBuilder().create();
        Gson responseMarshaller = null;
        if (responseInstance != null) {
            TypeAdapter responseTypeAdapter = new TypeAdapter<ResponseT>(){

                @Override
                public void write(JsonWriter out, ResponseT value) {
                    baseGson.toJson(value, responseInstance.getClass(), out);
                }

                @Override
                public ResponseT read(JsonReader in) {
                    return (ApiMessage)baseGson.fromJson(in, responseInstance.getClass());
                }
            };
            responseMarshaller = new GsonBuilder().registerTypeAdapter(responseInstance.getClass(), responseTypeAdapter).create();
        }
        return new AutoValue_ApiMessageHttpResponseParser<ResponseT>(responseInstance, responseMarshaller);
    }

    public static <ResponseT extends ApiMessage> Builder<ResponseT> newBuilder() {
        return new Builder();
    }

    @Override
    public ResponseT parse(InputStream httpResponseBody) {
        if (this.getResponseInstance() == null) {
            return null;
        }
        Class<?> responseType = this.getResponseInstance().getClass();
        try {
            return (ResponseT)((ApiMessage)this.getResponseMarshaller().fromJson((Reader)new InputStreamReader(httpResponseBody, StandardCharsets.UTF_8), (Type)responseType));
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw new RestSerializationException(e);
        }
    }

    @Override
    public ResponseT parse(InputStream httpResponseBody, TypeRegistry registry) {
        return (ResponseT)this.parse(httpResponseBody);
    }

    @Override
    public String serialize(ResponseT response) {
        return this.getResponseMarshaller().toJson(response);
    }

    public static class Builder<ResponseT extends ApiMessage> {
        private ResponseT responseInstance;

        private Builder() {
        }

        public Builder<ResponseT> setResponseInstance(ResponseT responseInstance) {
            this.responseInstance = responseInstance;
            return this;
        }

        public ApiMessageHttpResponseParser<ResponseT> build() {
            return ApiMessageHttpResponseParser.create(this.responseInstance);
        }
    }
}

