/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecPythonCorrelate
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    private static final String PYTHON_TABLE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.table.PythonTableFunctionOperator";
    private final FlinkJoinType joinType;
    private final RexCall invocation;

    public CommonExecPythonCorrelate(int id, ExecNodeContext context, ReadableConfig persistedConfig, FlinkJoinType joinType, RexCall invocation, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.joinType = joinType;
        this.invocation = invocation;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        Configuration pythonConfig = CommonPythonUtil.extractPythonConfiguration(planner.getExecEnv(), config);
        OneInputTransformation<RowData, RowData> transform = this.createPythonOneInputTransformation(inputTransform, config, pythonConfig);
        if (CommonPythonUtil.isPythonWorkerUsingManagedMemory(pythonConfig)) {
            transform.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.PYTHON);
        }
        return transform;
    }

    private OneInputTransformation<RowData, RowData> createPythonOneInputTransformation(Transformation<RowData> inputTransform, ExecNodeConfig config, Configuration pythonConfig) {
        Tuple2<int[], PythonFunctionInfo> extractResult = this.extractPythonTableFunctionInfo();
        int[] pythonUdtfInputOffsets = (int[])extractResult.f0;
        PythonFunctionInfo pythonFunctionInfo = (PythonFunctionInfo)extractResult.f1;
        InternalTypeInfo pythonOperatorInputRowType = (InternalTypeInfo)inputTransform.getOutputType();
        InternalTypeInfo pythonOperatorOutputRowType = InternalTypeInfo.of((RowType)((RowType)this.getOutputType()));
        OneInputStreamOperator<RowData, RowData> pythonOperator = this.getPythonTableFunctionOperator(config, pythonConfig, (InternalTypeInfo<RowData>)pythonOperatorInputRowType, (InternalTypeInfo<RowData>)pythonOperatorOutputRowType, pythonFunctionInfo, pythonUdtfInputOffsets);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationName(config), this.createTransformationDescription(config), pythonOperator, pythonOperatorOutputRowType, inputTransform.getParallelism());
    }

    private Tuple2<int[], PythonFunctionInfo> extractPythonTableFunctionInfo() {
        LinkedHashMap<RexNode, Integer> inputNodes = new LinkedHashMap<RexNode, Integer>();
        PythonFunctionInfo pythonTableFunctionInfo = CommonPythonUtil.createPythonFunctionInfo(this.invocation, inputNodes);
        int[] udtfInputOffsets = inputNodes.keySet().stream().filter(x -> x instanceof RexInputRef).map(x -> ((RexInputRef)x).getIndex()).mapToInt(i -> i).toArray();
        return Tuple2.of((Object)udtfInputOffsets, (Object)pythonTableFunctionInfo);
    }

    private OneInputStreamOperator<RowData, RowData> getPythonTableFunctionOperator(ExecNodeConfig config, Configuration pythonConfig, InternalTypeInfo<RowData> inputRowType, InternalTypeInfo<RowData> outputRowType, PythonFunctionInfo pythonFunctionInfo, int[] udtfInputOffsets) {
        Class<?> clazz = CommonPythonUtil.loadClass(PYTHON_TABLE_FUNCTION_OPERATOR_NAME);
        RowType inputType = inputRowType.toRowType();
        RowType outputType = outputRowType.toRowType();
        RowType udfInputType = (RowType)Projection.of((int[])udtfInputOffsets).project((LogicalType)inputType);
        RowType udfOutputType = (RowType)Projection.range((int)inputType.getFieldCount(), (int)outputType.getFieldCount()).project((LogicalType)outputType);
        try {
            Constructor<?> ctor = clazz.getConstructor(Configuration.class, PythonFunctionInfo.class, RowType.class, RowType.class, RowType.class, FlinkJoinType.class, GeneratedProjection.class);
            return (OneInputStreamOperator)ctor.newInstance(pythonConfig, pythonFunctionInfo, inputType, udfInputType, udfOutputType, this.joinType, ProjectionCodeGenerator.generateProjection(CodeGeneratorContext.apply(config.getTableConfig()), "UdtfInputProjection", inputType, udfInputType, udtfInputOffsets));
        }
        catch (Exception e) {
            throw new TableException("Python Table Function Operator constructed failed.", (Throwable)e);
        }
    }
}

