/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.graphite;

import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteUDP;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.dropwizard.ScheduledDropwizardReporter;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.reporter.InstantiateViaFactory;

@InstantiateViaFactory(factoryClassName="org.apache.flink.metrics.graphite.GraphiteReporterFactory")
@PublicEvolving
public class GraphiteReporter
extends ScheduledDropwizardReporter {
    public static final String ARG_PROTOCOL = "protocol";

    @Override
    public ScheduledReporter getReporter(MetricConfig config) {
        Protocol prot;
        String host = config.getString("host", null);
        int port = config.getInteger("port", -1);
        if (host == null || host.length() == 0 || port < 1) {
            throw new IllegalArgumentException("Invalid host/port configuration. Host: " + host + " Port: " + port);
        }
        String prefix = config.getString("prefix", null);
        String conversionRate = config.getString("rateConversion", null);
        String conversionDuration = config.getString("durationConversion", null);
        String protocol = config.getString(ARG_PROTOCOL, "TCP");
        GraphiteReporter.Builder builder = com.codahale.metrics.graphite.GraphiteReporter.forRegistry(this.registry);
        if (prefix != null) {
            builder.prefixedWith(prefix);
        }
        if (conversionRate != null) {
            builder.convertRatesTo(TimeUnit.valueOf(conversionRate));
        }
        if (conversionDuration != null) {
            builder.convertDurationsTo(TimeUnit.valueOf(conversionDuration));
        }
        try {
            prot = Protocol.valueOf(protocol);
        }
        catch (IllegalArgumentException iae) {
            this.log.warn("Invalid protocol configuration: " + protocol + " Expected: TCP or UDP, defaulting to TCP.");
            prot = Protocol.TCP;
        }
        this.log.info("Configured GraphiteReporter with {host:{}, port:{}, protocol:{}}", new Object[]{host, port, prot});
        switch (prot) {
            case UDP: {
                return builder.build(new GraphiteUDP(host, port));
            }
        }
        return builder.build(new Graphite(host, port));
    }

    private static enum Protocol {
        TCP,
        UDP;

    }
}

