/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineList {
    public static final Logger LOG = LoggerFactory.getLogger(MachineList.class);
    public static final String WILDCARD_VALUE = "*";
    private final boolean all;
    private final Set<InetAddress> inetAddresses;
    private final Collection<String> entries;
    private final List<SubnetUtils.SubnetInfo> cidrAddresses;
    private final InetAddressFactory addressFactory;

    public MachineList(String hostEntries) {
        this(hostEntries, InetAddressFactory.S_INSTANCE);
    }

    public MachineList(String hostEntries, InetAddressFactory addressFactory) {
        this(StringUtils.getTrimmedStringCollection(hostEntries), addressFactory);
    }

    public MachineList(Collection<String> hostEntries) {
        this(hostEntries, InetAddressFactory.S_INSTANCE);
    }

    public MachineList(Collection<String> hostEntries, InetAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
        if (hostEntries != null) {
            this.entries = new ArrayList<String>(hostEntries);
            if (hostEntries.size() == 1 && hostEntries.contains(WILDCARD_VALUE)) {
                this.all = true;
                this.inetAddresses = null;
                this.cidrAddresses = null;
            } else {
                this.all = false;
                HashSet<InetAddress> addrs = new HashSet<InetAddress>();
                LinkedList<SubnetUtils.SubnetInfo> cidrs = new LinkedList<SubnetUtils.SubnetInfo>();
                for (String hostEntry : hostEntries) {
                    if (hostEntry.indexOf("/") > -1) {
                        try {
                            SubnetUtils subnet = new SubnetUtils(hostEntry);
                            subnet.setInclusiveHostCount(true);
                            cidrs.add(subnet.getInfo());
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            LOG.warn("Invalid CIDR syntax : " + hostEntry);
                            throw e;
                        }
                    }
                    try {
                        addrs.add(addressFactory.getByName(hostEntry));
                    }
                    catch (UnknownHostException e) {
                        LOG.warn(e.toString());
                    }
                }
                this.inetAddresses = addrs.size() > 0 ? addrs : null;
                this.cidrAddresses = cidrs.size() > 0 ? cidrs : null;
            }
        } else {
            this.all = false;
            this.inetAddresses = null;
            this.cidrAddresses = null;
            this.entries = Collections.emptyList();
        }
    }

    public boolean includes(String ipAddress) {
        if (this.all) {
            return true;
        }
        if (ipAddress == null) {
            throw new IllegalArgumentException("ipAddress is null.");
        }
        try {
            return this.includes(this.addressFactory.getByName(ipAddress));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean includes(InetAddress address) {
        if (this.all) {
            return true;
        }
        if (address == null) {
            throw new IllegalArgumentException("address is null.");
        }
        if (this.inetAddresses != null && this.inetAddresses.contains(address)) {
            return true;
        }
        if (this.cidrAddresses != null) {
            String ipAddress = address.getHostAddress();
            for (SubnetUtils.SubnetInfo cidrAddress : this.cidrAddresses) {
                if (!cidrAddress.isInRange(ipAddress)) continue;
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    public Collection<String> getCollection() {
        return this.entries;
    }

    public static class InetAddressFactory {
        static final InetAddressFactory S_INSTANCE = new InetAddressFactory();

        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    }
}

