/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.lib;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.lib.Interns;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.metrics2.util.Contracts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MethodMetric
extends MutableMetric {
    private static final Logger LOG = LoggerFactory.getLogger(MethodMetric.class);
    private final Object obj;
    private final Method method;
    private final MetricsInfo info;
    private final MutableMetric impl;

    MethodMetric(Object obj, Method method, MetricsInfo info, Metric.Type type) {
        this.obj = Preconditions.checkNotNull(obj, "object");
        this.method = Contracts.checkArg(method, method.getParameterTypes().length == 0, (Object)"Metric method should have no arguments");
        this.method.setAccessible(true);
        this.info = Preconditions.checkNotNull(info, "info");
        this.impl = this.newImpl(Preconditions.checkNotNull(type, "metric type"));
    }

    private MutableMetric newImpl(Metric.Type metricType) {
        Class<?> resType = this.method.getReturnType();
        switch (metricType) {
            case COUNTER: {
                return this.newCounter(resType);
            }
            case GAUGE: {
                return this.newGauge(resType);
            }
            case DEFAULT: {
                return resType == String.class ? this.newTag(resType) : this.newGauge(resType);
            }
            case TAG: {
                return this.newTag(resType);
            }
        }
        Contracts.checkArg(metricType, false, (Object)"unsupported metric type");
        return null;
    }

    MutableMetric newCounter(final Class<?> type) {
        if (MethodMetric.isInt(type) || MethodMetric.isLong(type)) {
            return new MutableMetric(){

                @Override
                public void snapshot(MetricsRecordBuilder rb, boolean all) {
                    try {
                        Object ret = MethodMetric.this.method.invoke(MethodMetric.this.obj, (Object[])null);
                        if (MethodMetric.isInt(type)) {
                            rb.addCounter(MethodMetric.this.info, (Integer)ret);
                        } else {
                            rb.addCounter(MethodMetric.this.info, (Long)ret);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error("Error invoking method " + MethodMetric.this.method.getName(), (Throwable)ex);
                    }
                }
            };
        }
        throw new MetricsException("Unsupported counter type: " + type.getName());
    }

    static boolean isInt(Class<?> type) {
        boolean ret = type == Integer.TYPE || type == Integer.class;
        return ret;
    }

    static boolean isLong(Class<?> type) {
        return type == Long.TYPE || type == Long.class;
    }

    static boolean isFloat(Class<?> type) {
        return type == Float.TYPE || type == Float.class;
    }

    static boolean isDouble(Class<?> type) {
        return type == Double.TYPE || type == Double.class;
    }

    MutableMetric newGauge(final Class<?> t) {
        if (MethodMetric.isInt(t) || MethodMetric.isLong(t) || MethodMetric.isFloat(t) || MethodMetric.isDouble(t)) {
            return new MutableMetric(){

                @Override
                public void snapshot(MetricsRecordBuilder rb, boolean all) {
                    try {
                        Object ret = MethodMetric.this.method.invoke(MethodMetric.this.obj, (Object[])null);
                        if (MethodMetric.isInt(t)) {
                            rb.addGauge(MethodMetric.this.info, (Integer)ret);
                        } else if (MethodMetric.isLong(t)) {
                            rb.addGauge(MethodMetric.this.info, (Long)ret);
                        } else if (MethodMetric.isFloat(t)) {
                            rb.addGauge(MethodMetric.this.info, ((Float)ret).floatValue());
                        } else {
                            rb.addGauge(MethodMetric.this.info, (Double)ret);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error("Error invoking method " + MethodMetric.this.method.getName(), (Throwable)ex);
                    }
                }
            };
        }
        throw new MetricsException("Unsupported gauge type: " + t.getName());
    }

    MutableMetric newTag(Class<?> resType) {
        if (resType == String.class) {
            return new MutableMetric(){

                @Override
                public void snapshot(MetricsRecordBuilder rb, boolean all) {
                    try {
                        Object ret = MethodMetric.this.method.invoke(MethodMetric.this.obj, (Object[])null);
                        rb.tag(MethodMetric.this.info, (String)ret);
                    }
                    catch (Exception ex) {
                        LOG.error("Error invoking method " + MethodMetric.this.method.getName(), (Throwable)ex);
                    }
                }
            };
        }
        throw new MetricsException("Unsupported tag type: " + resType.getName());
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        this.impl.snapshot(builder, all);
    }

    static MetricsInfo metricInfo(Method method) {
        return Interns.info(MethodMetric.nameFrom(method), "Metric for " + method.getName());
    }

    static String nameFrom(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return StringUtils.capitalize(methodName.substring(3));
        }
        return StringUtils.capitalize(methodName);
    }
}

