/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.Credential;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.Endpoint;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.IEndpointsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.LocationConfig;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.ProductDomain;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InternalEndpointsParser
implements IEndpointsProvider {
    private static final String BUNDLED_ENDPOINTS_RESOURCE_PATH = "/org/apache/flink/fs/osshadoop/shaded/com/aliyuncs/endpoints/endpoints.xml";

    private static List<Endpoint> parseEndpoints(InputStream input) throws IOException, ParserConfigurationException, SAXException {
        Document document = XmlUtils.getDocument(new InputSource(input), null);
        NodeList endpointNodes = document.getElementsByTagName("Endpoint");
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (int i = 0; i < endpointNodes.getLength(); ++i) {
            int j;
            Element endpoint = (Element)endpointNodes.item(i);
            HashSet<String> regionIds = new HashSet<String>();
            ArrayList<ProductDomain> products = new ArrayList<ProductDomain>();
            NodeList regionNodes = endpoint.getElementsByTagName("RegionId");
            NodeList productNodes = endpoint.getElementsByTagName("Product");
            for (j = 0; j < regionNodes.getLength(); ++j) {
                regionIds.add(((Element)regionNodes.item(j)).getTextContent());
            }
            for (j = 0; j < productNodes.getLength(); ++j) {
                Element element = (Element)productNodes.item(j);
                NodeList productNames = element.getElementsByTagName("ProductName");
                NodeList domainNames = element.getElementsByTagName("DomainName");
                for (int k = 0; k < productNames.getLength(); ++k) {
                    String productName = ((Element)productNames.item(k)).getTextContent();
                    String domainName = ((Element)domainNames.item(k)).getTextContent();
                    products.add(new ProductDomain(productName, domainName));
                }
            }
            endpoints.add(new Endpoint(endpoint.getAttribute("name"), regionIds, products));
        }
        return endpoints;
    }

    public List<Endpoint> getEndpoints() throws ClientException {
        InputStream stream = this.getClass().getResourceAsStream(BUNDLED_ENDPOINTS_RESOURCE_PATH);
        try {
            return InternalEndpointsParser.parseEndpoints(stream);
        }
        catch (IOException e) {
            throw new ClientException("SDK.MissingEndpointsFile", "Internal endpoints file is missing.");
        }
        catch (ParserConfigurationException e) {
            throw new ClientException("SDK.InvalidEndpointsFile", "Internal endpoints file is missing.");
        }
        catch (SAXException e) {
            throw new ClientException("SDK.EndpointsFileMalformed", "Internal endpoints file is missing.");
        }
    }

    @Override
    public Endpoint getEndpoint(String region, String product) throws ClientException {
        InputStream stream = this.getClass().getResourceAsStream(BUNDLED_ENDPOINTS_RESOURCE_PATH);
        try {
            List<Endpoint> internalEndpoints = InternalEndpointsParser.parseEndpoints(stream);
            for (Endpoint endpoint : internalEndpoints) {
                for (String regionId : endpoint.getRegionIds()) {
                    if (!regionId.equals(region)) continue;
                    for (ProductDomain productDomain : endpoint.getProductDomains()) {
                        if (!productDomain.getProductName().equals(product)) continue;
                        HashSet<String> regionSet = new HashSet<String>();
                        regionSet.add(region);
                        ArrayList<ProductDomain> productDomains = new ArrayList<ProductDomain>();
                        productDomains.add(productDomain);
                        Endpoint resultEndpoint = new Endpoint(endpoint.getName(), regionSet, productDomains);
                        return resultEndpoint;
                    }
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new ClientException("SDK.MissingEndpointsFile", "Internal endpoints file is missing.");
        }
        catch (ParserConfigurationException e) {
            throw new ClientException("SDK.InvalidEndpointsFile", "Internal endpoints file is missing.");
        }
        catch (SAXException e) {
            throw new ClientException("SDK.EndpointsFileMalformed", "Internal endpoints file is missing.");
        }
    }

    @Override
    public Endpoint getEndpoint(String region, String product, String serviceCode, String endpointType, Credential credential, LocationConfig locationConfig) throws ClientException {
        throw new UnsupportedOperationException();
    }
}

