/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model;

import java.io.InputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.io.BoundedInputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.GenericRequest;

public class UploadPartRequest
extends GenericRequest {
    private String uploadId;
    private int partNumber;
    private long partSize = -1L;
    private String md5Digest;
    private InputStream inputStream;
    private boolean useChunkEncoding = false;

    public UploadPartRequest() {
    }

    public UploadPartRequest(String bucketName, String key) {
        super(bucketName, key);
    }

    public UploadPartRequest(String bucketName, String key, String uploadId, int partNumber, InputStream inputStream, long partSize) {
        super(bucketName, key);
        this.uploadId = uploadId;
        this.partNumber = partNumber;
        this.inputStream = inputStream;
        this.partSize = partSize;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }

    public String getMd5Digest() {
        return this.md5Digest;
    }

    public void setMd5Digest(String md5Digest) {
        this.md5Digest = md5Digest;
    }

    public boolean isUseChunkEncoding() {
        return this.useChunkEncoding || this.partSize == -1L;
    }

    public void setUseChunkEncoding(boolean useChunkEncoding) {
        this.useChunkEncoding = useChunkEncoding;
    }

    public BoundedInputStream buildPartialStream() {
        return new BoundedInputStream(this.inputStream, (int)this.partSize);
    }
}

