/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CannedAccessControlList;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.GenericResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.Grant;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.Grantee;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.Owner;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.Permission;

public class AccessControlList
extends GenericResult
implements Serializable {
    private static final long serialVersionUID = 211267925081748283L;
    private HashSet<Grant> grants = new HashSet();
    private CannedAccessControlList cannedACL;
    private Owner owner;

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void grantPermission(Grantee grantee, Permission permission) {
        if (grantee == null || permission == null) {
            throw new NullPointerException();
        }
        this.grants.add(new Grant(grantee, permission));
    }

    public void revokeAllPermissions(Grantee grantee) {
        if (grantee == null) {
            throw new NullPointerException();
        }
        ArrayList<Grant> grantsToRemove = new ArrayList<Grant>();
        for (Grant g2 : this.grants) {
            if (!g2.getGrantee().equals(g2)) continue;
            grantsToRemove.add(g2);
        }
        this.grants.removeAll(grantsToRemove);
    }

    @Deprecated
    public Set<Grant> getGrants() {
        return this.grants;
    }

    public CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    public void setCannedACL(CannedAccessControlList cannedACL) {
        this.cannedACL = cannedACL;
    }

    public String toString() {
        return "AccessControlList [owner=" + this.owner + ", ACL=" + (Object)((Object)this.getCannedACL()) + "]";
    }
}

