/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.BasicCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.LogUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.DefaultAcsClient;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.KeyPairCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.sts.GetSessionAccessKeyRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.sts.GetSessionAccessKeyResponse;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.ProtocolType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.profile.IClientProfile;

public class STSKeyPairSessionCredentialsProvider
implements CredentialsProvider {
    private DefaultAcsClient ramClient;
    private KeyPairCredentials keyPairCredentials;
    private BasicCredentials sessionCredentials;
    private long expiredDurationSeconds = 3600L;
    private double expiredFactor = 0.8;

    public STSKeyPairSessionCredentialsProvider(KeyPairCredentials keyPairCredentials, IClientProfile profile) {
        this.keyPairCredentials = keyPairCredentials;
        this.ramClient = new DefaultAcsClient(profile, keyPairCredentials);
    }

    public STSKeyPairSessionCredentialsProvider withExpiredDuration(long expiredDurationSeconds) {
        this.expiredDurationSeconds = expiredDurationSeconds;
        return this;
    }

    public STSKeyPairSessionCredentialsProvider withExpiredFactor(double expiredFactor) {
        this.expiredFactor = expiredFactor;
        return this;
    }

    @Override
    public void setCredentials(Credentials creds) {
    }

    @Override
    public Credentials getCredentials() {
        if (this.sessionCredentials == null || this.sessionCredentials.willSoonExpire()) {
            this.sessionCredentials = this.getNewSessionCredentials();
        }
        return this.sessionCredentials;
    }

    private BasicCredentials getNewSessionCredentials() {
        GetSessionAccessKeyRequest request = new GetSessionAccessKeyRequest();
        request.setPublicKeyId(this.keyPairCredentials.getAccessKeyId());
        request.setDurationSeconds((int)this.expiredDurationSeconds);
        request.setProtocol(ProtocolType.HTTPS);
        GetSessionAccessKeyResponse response = null;
        try {
            response = this.ramClient.getAcsResponse(request);
        }
        catch (ClientException e) {
            LogUtils.logException("RamClient.getAcsResponse Exception:", e);
            return null;
        }
        return new BasicCredentials(response.getSessionAccesskey().getSessionAccessKeyId(), response.getSessionAccesskey().getSessionAccessKeySecert(), null, this.expiredDurationSeconds).withExpiredFactor(this.expiredFactor);
    }
}

