/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import java.util.concurrent.Semaphore;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.ProfileConfigFile;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.AuthUtils;

public class ProfileCredentialsProvider
implements CredentialsProvider {
    private static final long DIFF_MILLI_AND_NANO = 1000000L;
    private static final long DEFAULT_REFRESH_INTERVAL_NANOS = 300000000000L;
    private static final long DEFAULT_FORCE_RELOAD_INTERVAL_NANOS = 600000000000L;
    private volatile ProfileConfigFile profilesConfigFile;
    private volatile long lastRefreshed;
    private final String profileName;
    private final Semaphore refreshSemaphore = new Semaphore(1);
    private long refreshIntervalNanos = 300000000000L;
    private long refreshForceIntervalNanos = 600000000000L;

    public ProfileCredentialsProvider() {
        this(null);
    }

    public ProfileCredentialsProvider(String profileName) {
        this((ProfileConfigFile)null, profileName);
    }

    public ProfileCredentialsProvider(String profilesConfigFilePath, String profileName) {
        this(new ProfileConfigFile(profilesConfigFilePath), profileName);
    }

    public ProfileCredentialsProvider(ProfileConfigFile profilesConfigFile, String profileName) {
        this.profilesConfigFile = profilesConfigFile;
        if (this.profilesConfigFile != null) {
            this.lastRefreshed = System.nanoTime();
        }
        this.profileName = profileName == null ? AuthUtils.DEFAULT_PROFILE_PATH : profileName;
    }

    @Override
    public void setCredentials(Credentials creds) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredentials() {
        long now;
        long age;
        if (this.profilesConfigFile == null) {
            ProfileCredentialsProvider profileCredentialsProvider = this;
            synchronized (profileCredentialsProvider) {
                if (this.profilesConfigFile == null) {
                    this.profilesConfigFile = new ProfileConfigFile(this.profileName);
                    this.lastRefreshed = System.nanoTime();
                }
            }
        }
        if ((age = (now = System.nanoTime()) - this.lastRefreshed) > this.refreshForceIntervalNanos) {
            this.refresh();
        } else if (age > this.refreshIntervalNanos && this.refreshSemaphore.tryAcquire()) {
            try {
                this.refresh();
            }
            finally {
                this.refreshSemaphore.release();
            }
        }
        return this.profilesConfigFile.getCredentials();
    }

    public void refresh() {
        if (this.profilesConfigFile != null) {
            this.profilesConfigFile.refresh();
            this.lastRefreshed = System.nanoTime();
        }
    }

    public long getRefreshIntervalMillis() {
        return this.refreshIntervalNanos / 1000000L;
    }

    public void setRefreshIntervalNanos(long refreshIntervalMillis) {
        this.refreshIntervalNanos = refreshIntervalMillis * 1000000L;
    }

    public long getRefreshForceIntervalMillis() {
        return this.refreshForceIntervalNanos / 1000000L;
    }

    public void setRefreshForceIntervalMillis(long refreshForceIntervalMillis) {
        this.refreshForceIntervalNanos = refreshForceIntervalMillis * 1000000L;
    }
}

