/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.json;

import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.SerializableString;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.Version;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.base.GeneratorBase;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.io.CharTypes;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.io.CharacterEscapes;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.io.IOContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.apache.flink.fs.shaded.hadoop3.org.apache.htrace.shaded.fasterxml.jackson.core.util.VersionUtil;

public abstract class JsonGeneratorImpl
extends GeneratorBase {
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    protected final IOContext _ioContext;
    protected int[] _outputEscapes = sOutputEscapes;
    protected int _maximumNonEscapedChar;
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;

    public JsonGeneratorImpl(IOContext ctxt, int features, ObjectCodec codec) {
        super(features, codec);
        this._ioContext = ctxt;
        if (this.isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
    }

    @Override
    public JsonGenerator setHighestNonEscapedChar(int charCode) {
        this._maximumNonEscapedChar = charCode < 0 ? 0 : charCode;
        return this;
    }

    @Override
    public int getHighestEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    @Override
    public JsonGenerator setCharacterEscapes(CharacterEscapes esc) {
        this._characterEscapes = esc;
        this._outputEscapes = esc == null ? sOutputEscapes : esc.getEscapeCodesForAscii();
        return this;
    }

    @Override
    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    @Override
    public JsonGenerator setRootValueSeparator(SerializableString sep) {
        this._rootValueSeparator = sep;
        return this;
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public final void writeStringField(String fieldName, String value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeString(value);
    }
}

