/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.DataInputBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.DataOutputBuffer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableComparator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.WritableUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Stable
public class UTF8
implements WritableComparable<UTF8> {
    private static final Logger LOG = LoggerFactory.getLogger(UTF8.class);
    private static final DataInputBuffer IBUF = new DataInputBuffer();
    private static final ThreadLocal<DataOutputBuffer> OBUF_FACTORY = new ThreadLocal<DataOutputBuffer>(){

        @Override
        protected DataOutputBuffer initialValue() {
            return new DataOutputBuffer();
        }
    };
    private static final byte[] EMPTY_BYTES = new byte[0];
    private byte[] bytes = EMPTY_BYTES;
    private int length;

    public UTF8() {
    }

    public UTF8(String string) {
        this.set(string);
    }

    public UTF8(UTF8 utf8) {
        this.set(utf8);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public void set(String string) {
        if (string.length() > 21845) {
            LOG.warn("truncating long string: " + string.length() + " chars, starting with " + string.substring(0, 20));
            string = string.substring(0, 21845);
        }
        this.length = UTF8.utf8Length(string);
        if (this.length > 65535) {
            throw new RuntimeException("string too long!");
        }
        if (this.bytes == null || this.length > this.bytes.length) {
            this.bytes = new byte[this.length];
        }
        try {
            DataOutputBuffer obuf = OBUF_FACTORY.get();
            obuf.reset();
            UTF8.writeChars(obuf, string, 0, string.length());
            System.arraycopy(obuf.getData(), 0, this.bytes, 0, this.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(UTF8 other) {
        this.length = other.length;
        if (this.bytes == null || this.length > this.bytes.length) {
            this.bytes = new byte[this.length];
        }
        System.arraycopy(other.bytes, 0, this.bytes, 0, this.length);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.length = in.readUnsignedShort();
        if (this.bytes == null || this.bytes.length < this.length) {
            this.bytes = new byte[this.length];
        }
        in.readFully(this.bytes, 0, this.length);
    }

    public static void skip(DataInput in) throws IOException {
        int length = in.readUnsignedShort();
        WritableUtils.skipFully(in, length);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.length);
        out.write(this.bytes, 0, this.length);
    }

    @Override
    public int compareTo(UTF8 o) {
        return WritableComparator.compareBytes(this.bytes, 0, this.length, o.bytes, 0, o.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.length);
        try {
            DataInputBuffer dataInputBuffer = IBUF;
            synchronized (dataInputBuffer) {
                IBUF.reset(this.bytes, this.length);
                UTF8.readChars(IBUF, buffer, this.length);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringChecked() throws IOException {
        StringBuilder buffer = new StringBuilder(this.length);
        DataInputBuffer dataInputBuffer = IBUF;
        synchronized (dataInputBuffer) {
            IBUF.reset(this.bytes, this.length);
            UTF8.readChars(IBUF, buffer, this.length);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof UTF8)) {
            return false;
        }
        UTF8 that = (UTF8)o;
        if (this.length != that.length) {
            return false;
        }
        return WritableComparator.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length) == 0;
    }

    public int hashCode() {
        return WritableComparator.hashBytes(this.bytes, this.length);
    }

    public static byte[] getBytes(String string) {
        byte[] result = new byte[UTF8.utf8Length(string)];
        try {
            DataOutputBuffer obuf = OBUF_FACTORY.get();
            obuf.reset();
            UTF8.writeChars(obuf, string, 0, string.length());
            System.arraycopy(obuf.getData(), 0, result, 0, obuf.getLength());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String fromBytes(byte[] bytes) throws IOException {
        DataInputBuffer dbuf = new DataInputBuffer();
        dbuf.reset(bytes, 0, bytes.length);
        StringBuilder buf = new StringBuilder(bytes.length);
        UTF8.readChars(dbuf, buf, bytes.length);
        return buf.toString();
    }

    public static String readString(DataInput in) throws IOException {
        int bytes = in.readUnsignedShort();
        StringBuilder buffer = new StringBuilder(bytes);
        UTF8.readChars(in, buffer, bytes);
        return buffer.toString();
    }

    private static void readChars(DataInput in, StringBuilder buffer, int nBytes) throws UTFDataFormatException, IOException {
        DataOutputBuffer obuf = OBUF_FACTORY.get();
        obuf.reset();
        obuf.write(in, nBytes);
        byte[] bytes = obuf.getData();
        int i = 0;
        while (i < nBytes) {
            byte b;
            if (((b = bytes[i++]) & 0x80) == 0) {
                buffer.append((char)(b & 0x7F));
                continue;
            }
            if ((b & 0xE0) == 192) {
                if (i >= nBytes) {
                    throw new UTFDataFormatException("Truncated UTF8 at " + StringUtils.byteToHexString(bytes, i - 1, 1));
                }
                buffer.append((char)((b & 0x1F) << 6 | bytes[i++] & 0x3F));
                continue;
            }
            if ((b & 0xF0) == 224) {
                if (i + 1 >= nBytes) {
                    throw new UTFDataFormatException("Truncated UTF8 at " + StringUtils.byteToHexString(bytes, i - 1, 2));
                }
                buffer.append((char)((b & 0xF) << 12 | (bytes[i++] & 0x3F) << 6 | bytes[i++] & 0x3F));
                continue;
            }
            if ((b & 0xF8) == 240) {
                if (i + 2 >= nBytes) {
                    throw new UTFDataFormatException("Truncated UTF8 at " + StringUtils.byteToHexString(bytes, i - 1, 3));
                }
                int codepoint = (b & 7) << 18 | (bytes[i++] & 0x3F) << 12 | (bytes[i++] & 0x3F) << 6 | bytes[i++] & 0x3F;
                buffer.append(UTF8.highSurrogate(codepoint)).append(UTF8.lowSurrogate(codepoint));
                continue;
            }
            int endForError = Math.min(i + 5, nBytes);
            throw new UTFDataFormatException("Invalid UTF8 at " + StringUtils.byteToHexString(bytes, i - 1, endForError));
        }
    }

    private static char highSurrogate(int codePoint) {
        return (char)((codePoint >>> 10) + 55232);
    }

    private static char lowSurrogate(int codePoint) {
        return (char)((codePoint & 0x3FF) + 56320);
    }

    public static int writeString(DataOutput out, String s2) throws IOException {
        int len;
        if (s2.length() > 21845) {
            LOG.warn("truncating long string: " + s2.length() + " chars, starting with " + s2.substring(0, 20));
            s2 = s2.substring(0, 21845);
        }
        if ((len = UTF8.utf8Length(s2)) > 65535) {
            throw new IOException("string too long!");
        }
        out.writeShort(len);
        UTF8.writeChars(out, s2, 0, s2.length());
        return len;
    }

    private static int utf8Length(String string) {
        int stringLength = string.length();
        int utf8Length = 0;
        for (int i = 0; i < stringLength; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                ++utf8Length;
                continue;
            }
            if (c > '\u07ff') {
                utf8Length += 3;
                continue;
            }
            utf8Length += 2;
        }
        return utf8Length;
    }

    private static void writeChars(DataOutput out, String s2, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char code = s2.charAt(i);
            if (code <= '\u007f') {
                out.writeByte((byte)code);
                continue;
            }
            if (code <= '\u07ff') {
                out.writeByte((byte)(0xC0 | code >> 6 & 0x1F));
                out.writeByte((byte)(0x80 | code & 0x3F));
                continue;
            }
            out.writeByte((byte)(0xE0 | code >> 12 & 0xF));
            out.writeByte((byte)(0x80 | code >> 6 & 0x3F));
            out.writeByte((byte)(0x80 | code & 0x3F));
        }
    }

    static {
        WritableComparator.define(UTF8.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(UTF8.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int n1 = Comparator.readUnsignedShort(b1, s1);
            int n2 = Comparator.readUnsignedShort(b2, s2);
            return Comparator.compareBytes(b1, s1 + 2, n1, b2, s2 + 2, n2);
        }
    }
}

