/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.flink.fs.azure.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.azure.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.azure.shaded.com.google.common.base.Strings;
import org.apache.flink.fs.azure.shaded.org.apache.http.client.utils.URIBuilder;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.FileSystemOperationUnhandledException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAbfsRestOperationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidFileSystemPropertyException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriAuthorityException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.services.ListResultEntrySchema;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.contracts.services.ListResultSchema;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.oauth2.IdentityTransformer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsAclHelper;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsPerfInfo;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsPerfTracker;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsPermission;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.utils.Base64;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.utils.CRC64;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.AclEntry;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.AclStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsAction;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AzureBlobFileSystemStore {
    private static final Logger LOG = LoggerFactory.getLogger(AzureBlobFileSystemStore.class);
    private AbfsClient client;
    private URI uri;
    private String userName;
    private String primaryUserGroup;
    private static final String DATE_TIME_PATTERN = "E, dd MMM yyyy HH:mm:ss z";
    private static final String TOKEN_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'";
    private static final String XMS_PROPERTIES_ENCODING = "ISO-8859-1";
    private static final int LIST_MAX_RESULTS = 500;
    private static final int GET_SET_AGGREGATE_COUNT = 2;
    private final AbfsConfiguration abfsConfiguration;
    private final Set<String> azureAtomicRenameDirSet;
    private boolean isNamespaceEnabledSet;
    private boolean isNamespaceEnabled;
    private final AuthType authType;
    private final UserGroupInformation userGroupInformation;
    private final IdentityTransformer identityTransformer;
    private final AbfsPerfTracker abfsPerfTracker;

    public AzureBlobFileSystemStore(URI uri, boolean isSecureScheme, Configuration configuration) throws IOException {
        this.uri = uri;
        String[] authorityParts = this.authorityParts(uri);
        String fileSystemName = authorityParts[0];
        String accountName = authorityParts[1];
        try {
            this.abfsConfiguration = new AbfsConfiguration(configuration, accountName);
        }
        catch (IllegalAccessException exception) {
            throw new FileSystemOperationUnhandledException(exception);
        }
        LOG.trace("AbfsConfiguration init complete");
        this.userGroupInformation = UserGroupInformation.getCurrentUser();
        this.userName = this.userGroupInformation.getShortUserName();
        LOG.trace("UGI init complete");
        if (!this.abfsConfiguration.getSkipUserGroupMetadataDuringInitialization()) {
            try {
                this.primaryUserGroup = this.userGroupInformation.getPrimaryGroupName();
            }
            catch (IOException ex) {
                LOG.error("Failed to get primary group for {}, using user name as primary group name", (Object)this.userName);
                this.primaryUserGroup = this.userName;
            }
        } else {
            this.primaryUserGroup = this.userName;
        }
        LOG.trace("primaryUserGroup is {}", (Object)this.primaryUserGroup);
        this.azureAtomicRenameDirSet = new HashSet<String>(Arrays.asList(this.abfsConfiguration.getAzureAtomicRenameDirs().split(",")));
        this.authType = this.abfsConfiguration.getAuthType(accountName);
        boolean usingOauth = this.authType == AuthType.OAuth;
        boolean useHttps = usingOauth || this.abfsConfiguration.isHttpsAlwaysUsed() ? true : isSecureScheme;
        this.abfsPerfTracker = new AbfsPerfTracker(fileSystemName, accountName, this.abfsConfiguration);
        this.initializeClient(uri, fileSystemName, accountName, useHttps);
        this.identityTransformer = new IdentityTransformer(this.abfsConfiguration.getRawConfiguration());
        LOG.trace("IdentityTransformer init complete");
    }

    public String getUser() {
        return this.userName;
    }

    public String getPrimaryGroup() {
        return this.primaryUserGroup;
    }

    byte[] encodeAttribute(String value) throws UnsupportedEncodingException {
        return value.getBytes(XMS_PROPERTIES_ENCODING);
    }

    String decodeAttribute(byte[] value) throws UnsupportedEncodingException {
        return new String(value, XMS_PROPERTIES_ENCODING);
    }

    private String[] authorityParts(URI uri) throws InvalidUriAuthorityException, InvalidUriException {
        String authority = uri.getRawAuthority();
        if (null == authority) {
            throw new InvalidUriAuthorityException(uri.toString());
        }
        if (!authority.contains("@")) {
            throw new InvalidUriAuthorityException(uri.toString());
        }
        String[] authorityParts = authority.split("@", 2);
        if (authorityParts.length < 2 || authorityParts[0] != null && authorityParts[0].isEmpty()) {
            String errMsg = String.format("'%s' has a malformed authority, expected container name. Authority takes the form abfs://[<container name>@]<account name>", uri.toString());
            throw new InvalidUriException(errMsg);
        }
        return authorityParts;
    }

    public boolean getIsNamespaceEnabled() throws AzureBlobFileSystemException {
        if (!this.isNamespaceEnabledSet) {
            LOG.debug("Get root ACL status");
            try (AbfsPerfInfo perfInfo = this.startTracking("getIsNamespaceEnabled", "getAclStatus");){
                AbfsRestOperation op = this.client.getAclStatus("//");
                perfInfo.registerResult(op.getResult());
                this.isNamespaceEnabled = true;
                perfInfo.registerSuccess(true);
            }
            catch (AbfsRestOperationException ex) {
                if (400 != ex.getStatusCode()) {
                    throw ex;
                }
                this.isNamespaceEnabled = false;
            }
            this.isNamespaceEnabledSet = true;
        }
        return this.isNamespaceEnabled;
    }

    @VisibleForTesting
    URIBuilder getURIBuilder(String hostName, boolean isSecure) {
        String scheme = isSecure ? "https" : "http";
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(scheme);
        String endPoint = this.abfsConfiguration.get("fs.azure.abfs.endpoint");
        if (endPoint == null || !endPoint.contains(":")) {
            uriBuilder.setHost(hostName);
            return uriBuilder;
        }
        String[] data = endPoint.split(":");
        if (data.length != 2) {
            throw new RuntimeException(String.format("ABFS endpoint is not set correctly : %s, Do not specify scheme when using {IP}:{PORT}", endPoint));
        }
        uriBuilder.setHost(data[0].trim());
        uriBuilder.setPort(Integer.parseInt(data[1].trim()));
        uriBuilder.setPath("/" + UriUtils.extractAccountNameFromHostName(hostName));
        return uriBuilder;
    }

    public AbfsConfiguration getAbfsConfiguration() {
        return this.abfsConfiguration;
    }

    public Hashtable<String, String> getFilesystemProperties() throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getFilesystemProperties", "getFilesystemProperties");){
            LOG.debug("getFilesystemProperties for filesystem: {}", (Object)this.client.getFileSystem());
            AbfsRestOperation op = this.client.getFilesystemProperties();
            perfInfo.registerResult(op.getResult());
            String xMsProperties = op.getResult().getResponseHeader("x-ms-properties");
            Hashtable<String, String> parsedXmsProperties = this.parseCommaSeparatedXmsProperties(xMsProperties);
            perfInfo.registerSuccess(true);
            Hashtable<String, String> hashtable = parsedXmsProperties;
            return hashtable;
        }
    }

    public void setFilesystemProperties(Hashtable<String, String> properties) throws AzureBlobFileSystemException {
        if (properties == null || properties.isEmpty()) {
            LOG.trace("setFilesystemProperties no properties present");
            return;
        }
        LOG.debug("setFilesystemProperties for filesystem: {} with properties: {}", (Object)this.client.getFileSystem(), properties);
        try (AbfsPerfInfo perfInfo = this.startTracking("setFilesystemProperties", "setFilesystemProperties");){
            String commaSeparatedProperties;
            try {
                commaSeparatedProperties = this.convertXmsPropertiesToCommaSeparatedString(properties);
            }
            catch (CharacterCodingException ex) {
                throw new InvalidAbfsRestOperationException(ex);
            }
            AbfsRestOperation op = this.client.setFilesystemProperties(commaSeparatedProperties);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public Hashtable<String, String> getPathStatus(Path path) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getPathStatus", "getPathStatus");){
            LOG.debug("getPathStatus for filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
            AbfsRestOperation op = this.client.getPathStatus("/" + this.getRelativePath(path));
            perfInfo.registerResult(op.getResult());
            String xMsProperties = op.getResult().getResponseHeader("x-ms-properties");
            Hashtable<String, String> parsedXmsProperties = this.parseCommaSeparatedXmsProperties(xMsProperties);
            perfInfo.registerSuccess(true);
            Hashtable<String, String> hashtable = parsedXmsProperties;
            return hashtable;
        }
    }

    public void setPathProperties(Path path, Hashtable<String, String> properties) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("setPathProperties", "setPathProperties");){
            String commaSeparatedProperties;
            LOG.debug("setFilesystemProperties for filesystem: {} path: {} with properties: {}", new Object[]{this.client.getFileSystem(), path, properties});
            try {
                commaSeparatedProperties = this.convertXmsPropertiesToCommaSeparatedString(properties);
            }
            catch (CharacterCodingException ex) {
                throw new InvalidAbfsRestOperationException(ex);
            }
            AbfsRestOperation op = this.client.setPathProperties("/" + this.getRelativePath(path), commaSeparatedProperties);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void createFilesystem() throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createFilesystem", "createFilesystem");){
            LOG.debug("createFilesystem for filesystem: {}", (Object)this.client.getFileSystem());
            AbfsRestOperation op = this.client.createFilesystem();
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void deleteFilesystem() throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("deleteFilesystem", "deleteFilesystem");){
            LOG.debug("deleteFilesystem for filesystem: {}", (Object)this.client.getFileSystem());
            AbfsRestOperation op = this.client.deleteFilesystem();
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public OutputStream createFile(Path path, boolean overwrite, FsPermission permission, FsPermission umask) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createFile", "createPath");){
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled();
            LOG.debug("createFile filesystem: {} path: {} overwrite: {} permission: {} umask: {} isNamespaceEnabled: {}", new Object[]{this.client.getFileSystem(), path, overwrite, permission.toString(), umask.toString(), isNamespaceEnabled});
            AbfsRestOperation op = this.client.createPath("/" + this.getRelativePath(path), true, overwrite, isNamespaceEnabled ? this.getOctalNotation(permission) : null, isNamespaceEnabled ? this.getOctalNotation(umask) : null);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
            AbfsOutputStream abfsOutputStream = new AbfsOutputStream(this.client, "/" + this.getRelativePath(path), 0L, this.abfsConfiguration.getWriteBufferSize(), this.abfsConfiguration.isFlushEnabled(), this.abfsConfiguration.isOutputStreamFlushDisabled());
            return abfsOutputStream;
        }
    }

    public void createDirectory(Path path, FsPermission permission, FsPermission umask) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("createDirectory", "createPath");){
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled();
            LOG.debug("createDirectory filesystem: {} path: {} permission: {} umask: {} isNamespaceEnabled: {}", new Object[]{this.client.getFileSystem(), path, permission, umask, isNamespaceEnabled});
            AbfsRestOperation op = this.client.createPath("/" + this.getRelativePath(path), false, true, isNamespaceEnabled ? this.getOctalNotation(permission) : null, isNamespaceEnabled ? this.getOctalNotation(umask) : null);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public AbfsInputStream openFileForRead(Path path, FileSystem.Statistics statistics) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("openFileForRead", "getPathStatus");){
            LOG.debug("openFileForRead filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path);
            AbfsRestOperation op = this.client.getPathStatus("/" + this.getRelativePath(path));
            perfInfo.registerResult(op.getResult());
            String resourceType = op.getResult().getResponseHeader("x-ms-resource-type");
            long contentLength = Long.parseLong(op.getResult().getResponseHeader("Content-Length"));
            String eTag = op.getResult().getResponseHeader("ETag");
            if (this.parseIsDirectory(resourceType)) {
                throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "openFileForRead must be used with files and not directories", null);
            }
            perfInfo.registerSuccess(true);
            AbfsInputStream abfsInputStream = new AbfsInputStream(this.client, statistics, "/" + this.getRelativePath(path), contentLength, this.abfsConfiguration.getReadBufferSize(), this.abfsConfiguration.getReadAheadQueueDepth(), this.abfsConfiguration.getTolerateOobAppends(), eTag);
            return abfsInputStream;
        }
    }

    public OutputStream openFileForWrite(Path path, boolean overwrite) throws AzureBlobFileSystemException {
        try (AbfsPerfInfo perfInfo = this.startTracking("openFileForWrite", "getPathStatus");){
            LOG.debug("openFileForWrite filesystem: {} path: {} overwrite: {}", new Object[]{this.client.getFileSystem(), path, overwrite});
            AbfsRestOperation op = this.client.getPathStatus("/" + this.getRelativePath(path));
            perfInfo.registerResult(op.getResult());
            String resourceType = op.getResult().getResponseHeader("x-ms-resource-type");
            Long contentLength = Long.valueOf(op.getResult().getResponseHeader("Content-Length"));
            if (this.parseIsDirectory(resourceType)) {
                throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "openFileForRead must be used with files and not directories", null);
            }
            long offset = overwrite ? 0L : contentLength;
            perfInfo.registerSuccess(true);
            AbfsOutputStream abfsOutputStream = new AbfsOutputStream(this.client, "/" + this.getRelativePath(path), offset, this.abfsConfiguration.getWriteBufferSize(), this.abfsConfiguration.isFlushEnabled(), this.abfsConfiguration.isOutputStreamFlushDisabled());
            return abfsOutputStream;
        }
    }

    public void rename(Path source, Path destination) throws AzureBlobFileSystemException {
        boolean shouldContinue;
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        if (this.isAtomicRenameKey(source.getName())) {
            LOG.warn("The atomic rename feature is not supported by the ABFS scheme; however rename, create and delete operations are atomic if Namespace is enabled for your Azure Storage account.");
        }
        LOG.debug("renameAsync filesystem: {} source: {} destination: {}", new Object[]{this.client.getFileSystem(), source, destination});
        String continuation = null;
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("rename", "renamePath");){
                AbfsRestOperation op = this.client.renamePath("/" + this.getRelativePath(source), "/" + this.getRelativePath(destination), continuation);
                perfInfo.registerResult(op.getResult());
                continuation = op.getResult().getResponseHeader("x-ms-continuation");
                perfInfo.registerSuccess(true);
                ++countAggregate;
                boolean bl = shouldContinue = continuation != null && !continuation.isEmpty();
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
    }

    public void delete(Path path, boolean recursive) throws AzureBlobFileSystemException {
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        boolean shouldContinue = true;
        LOG.debug("delete filesystem: {} path: {} recursive: {}", new Object[]{this.client.getFileSystem(), path, String.valueOf(recursive)});
        String continuation = null;
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("delete", "deletePath");){
                AbfsRestOperation op = this.client.deletePath("/" + this.getRelativePath(path), recursive, continuation);
                perfInfo.registerResult(op.getResult());
                continuation = op.getResult().getResponseHeader("x-ms-continuation");
                perfInfo.registerSuccess(true);
                ++countAggregate;
                boolean bl = shouldContinue = continuation != null && !continuation.isEmpty();
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        try (AbfsPerfInfo perfInfo = this.startTracking("getFileStatus", "undetermined");){
            boolean resourceIsDir;
            long contentLength;
            AbfsRestOperation op;
            boolean isNamespaceEnabled = this.getIsNamespaceEnabled();
            LOG.debug("getFileStatus filesystem: {} path: {} isNamespaceEnabled: {}", new Object[]{this.client.getFileSystem(), path, isNamespaceEnabled});
            if (path.isRoot()) {
                if (isNamespaceEnabled) {
                    perfInfo.registerCallee("getAclStatus");
                    op = this.client.getAclStatus("//");
                } else {
                    perfInfo.registerCallee("getFilesystemProperties");
                    op = this.client.getFilesystemProperties();
                }
            } else {
                perfInfo.registerCallee("getPathStatus");
                op = this.client.getPathStatus("/" + this.getRelativePath(path));
            }
            perfInfo.registerResult(op.getResult());
            long blockSize = this.abfsConfiguration.getAzureBlockSize();
            AbfsHttpOperation result = op.getResult();
            String eTag = result.getResponseHeader("ETag");
            String lastModified = result.getResponseHeader("Last-Modified");
            String permissions = result.getResponseHeader("x-ms-permissions");
            boolean hasAcl = AbfsPermission.isExtendedAcl(permissions);
            if (path.isRoot()) {
                contentLength = 0L;
                resourceIsDir = true;
            } else {
                contentLength = this.parseContentLength(result.getResponseHeader("Content-Length"));
                resourceIsDir = this.parseIsDirectory(result.getResponseHeader("x-ms-resource-type"));
            }
            String transformedOwner = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-owner"), true, this.userName);
            String transformedGroup = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-group"), false, this.primaryUserGroup);
            perfInfo.registerSuccess(true);
            VersionedFileStatus versionedFileStatus = new VersionedFileStatus(transformedOwner, transformedGroup, permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions), hasAcl, contentLength, resourceIsDir, 1, blockSize, this.parseLastModifiedTime(lastModified), path, eTag);
            return versionedFileStatus;
        }
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.listStatus(path, null);
    }

    @InterfaceStability.Unstable
    public FileStatus[] listStatus(Path path, String startFrom) throws IOException {
        Instant startAggregate = this.abfsPerfTracker.getLatencyInstant();
        long countAggregate = 0L;
        boolean shouldContinue = true;
        LOG.debug("listStatus filesystem: {} path: {}, startFrom: {}", new Object[]{this.client.getFileSystem(), path, startFrom});
        String relativePath = path.isRoot() ? "" : this.getRelativePath(path);
        String continuation = null;
        if (startFrom != null && !startFrom.isEmpty()) {
            continuation = this.getIsNamespaceEnabled() ? this.generateContinuationTokenForXns(startFrom) : this.generateContinuationTokenForNonXns(path.isRoot() ? "/" : relativePath, startFrom);
        }
        ArrayList<VersionedFileStatus> fileStatuses = new ArrayList<VersionedFileStatus>();
        do {
            try (AbfsPerfInfo perfInfo = this.startTracking("listStatus", "listPath");){
                AbfsRestOperation op = this.client.listPath(relativePath, false, 500, continuation);
                perfInfo.registerResult(op.getResult());
                continuation = op.getResult().getResponseHeader("x-ms-continuation");
                ListResultSchema retrievedSchema = op.getResult().getListResultSchema();
                if (retrievedSchema == null) {
                    throw new AbfsRestOperationException(AzureServiceErrorCode.PATH_NOT_FOUND.getStatusCode(), AzureServiceErrorCode.PATH_NOT_FOUND.getErrorCode(), "listStatusAsync path not found", null, op.getResult());
                }
                long blockSize = this.abfsConfiguration.getAzureBlockSize();
                for (ListResultEntrySchema entry : retrievedSchema.paths()) {
                    boolean isDirectory;
                    String owner = this.identityTransformer.transformIdentityForGetRequest(entry.owner(), true, this.userName);
                    String group = this.identityTransformer.transformIdentityForGetRequest(entry.group(), false, this.primaryUserGroup);
                    AbfsPermission fsPermission = entry.permissions() == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(entry.permissions());
                    boolean hasAcl = AbfsPermission.isExtendedAcl(entry.permissions());
                    long lastModifiedMillis = 0L;
                    long contentLength = entry.contentLength() == null ? 0L : entry.contentLength();
                    boolean bl = isDirectory = entry.isDirectory() == null ? false : entry.isDirectory();
                    if (entry.lastModified() != null && !entry.lastModified().isEmpty()) {
                        lastModifiedMillis = this.parseLastModifiedTime(entry.lastModified());
                    }
                    Path entryPath = new Path(File.separator + entry.name());
                    entryPath = entryPath.makeQualified(this.uri, entryPath);
                    fileStatuses.add(new VersionedFileStatus(owner, group, fsPermission, hasAcl, contentLength, isDirectory, 1, blockSize, lastModifiedMillis, entryPath, entry.eTag()));
                }
                perfInfo.registerSuccess(true);
                ++countAggregate;
                boolean bl = shouldContinue = continuation != null && !continuation.isEmpty();
                if (shouldContinue) continue;
                perfInfo.registerAggregates(startAggregate, countAggregate);
            }
        } while (shouldContinue);
        return fileStatuses.toArray(new FileStatus[fileStatuses.size()]);
    }

    private String generateContinuationTokenForXns(String firstEntryName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(firstEntryName) && !firstEntryName.startsWith("/"), "startFrom must be a dir/file name and it can not be a full path");
        StringBuilder sb = new StringBuilder();
        sb.append(firstEntryName).append("#$").append("0");
        CRC64 crc64 = new CRC64();
        StringBuilder token = new StringBuilder();
        token.append(crc64.compute(sb.toString().getBytes(StandardCharsets.UTF_8))).append(" ").append("0").append(" ").append(firstEntryName);
        return Base64.encode(token.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String generateContinuationTokenForNonXns(String path, String firstEntryName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(firstEntryName) && !firstEntryName.startsWith("/"), "startFrom must be a dir/file name and it can not be a full path");
        String startFrom = path.isEmpty() || path.equals("/") ? firstEntryName : path + "/" + firstEntryName;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TOKEN_DATE_PATTERN, Locale.US);
        String date = simpleDateFormat.format(new Date());
        String token = String.format("%06d!%s!%06d!%s!%06d!%s!", path.length(), path, startFrom.length(), startFrom, date.length(), date);
        String base64EncodedToken = Base64.encode(token.getBytes(StandardCharsets.UTF_8));
        StringBuilder encodedTokenBuilder = new StringBuilder(base64EncodedToken.length() + 5);
        encodedTokenBuilder.append(String.format("%s!%d!", "2", base64EncodedToken.length()));
        for (int i = 0; i < base64EncodedToken.length(); ++i) {
            int current = base64EncodedToken.charAt(i);
            if (47 == current) {
                current = 95;
            } else if (43 == current) {
                current = 42;
            } else if (61 == current) {
                current = 45;
            }
            encodedTokenBuilder.append((char)current);
        }
        return encodedTokenBuilder.toString();
    }

    public void setOwner(Path path, String owner, String group) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("setOwner", "setOwner");){
            LOG.debug("setOwner filesystem: {} path: {} owner: {} group: {}", new Object[]{this.client.getFileSystem(), path.toString(), owner, group});
            String transformedOwner = this.identityTransformer.transformUserOrGroupForSetRequest(owner);
            String transformedGroup = this.identityTransformer.transformUserOrGroupForSetRequest(group);
            AbfsRestOperation op = this.client.setOwner("/" + this.getRelativePath(path, true), transformedOwner, transformedGroup);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void setPermission(Path path, FsPermission permission) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("setPermission", "setPermission");){
            LOG.debug("setPermission filesystem: {} path: {} permission: {}", new Object[]{this.client.getFileSystem(), path.toString(), permission.toString()});
            AbfsRestOperation op = this.client.setPermission("/" + this.getRelativePath(path, true), String.format("%04d", permission.toOctal()));
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("modifyAclEntries", "getAclStatus");){
            LOG.debug("modifyAclEntries filesystem: {} path: {} aclSpec: {}", new Object[]{this.client.getFileSystem(), path.toString(), AclEntry.aclSpecToString(aclSpec)});
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> modifyAclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean useUpn = AbfsAclHelper.isUpnFormatAclEntries(modifyAclEntries);
            AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true), useUpn);
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.modifyAclEntriesInternal(aclEntries, modifyAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("modifyAclEntries", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(aclEntries), eTag);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeAclEntries", "getAclStatus");){
            LOG.debug("removeAclEntries filesystem: {} path: {} aclSpec: {}", new Object[]{this.client.getFileSystem(), path.toString(), AclEntry.aclSpecToString(aclSpec)});
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> removeAclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean isUpnFormat = AbfsAclHelper.isUpnFormatAclEntries(removeAclEntries);
            AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true), isUpnFormat);
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.removeAclEntriesInternal(aclEntries, removeAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeAclEntries", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(aclEntries), eTag);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeDefaultAcl(Path path) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeDefaultAcl", "getAclStatus");){
            LOG.debug("removeDefaultAcl filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path.toString());
            AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            HashMap<String, String> defaultAclEntries = new HashMap<String, String>();
            for (Map.Entry<String, String> aclEntry : aclEntries.entrySet()) {
                if (!aclEntry.getKey().startsWith("default:")) continue;
                defaultAclEntries.put(aclEntry.getKey(), aclEntry.getValue());
            }
            aclEntries.keySet().removeAll(defaultAclEntries.keySet());
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeDefaultAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(aclEntries), eTag);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void removeAcl(Path path) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("removeAcl", "getAclStatus");){
            LOG.debug("removeAcl filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path.toString());
            AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            HashMap<String, String> newAclEntries = new HashMap<String, String>();
            newAclEntries.put("user:", aclEntries.get("user:"));
            newAclEntries.put("group:", aclEntries.get("group:"));
            newAclEntries.put("other:", aclEntries.get("other:"));
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("removeAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(newAclEntries), eTag);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws AzureBlobFileSystemException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfoGet = this.startTracking("setAcl", "getAclStatus");){
            LOG.debug("setAcl filesystem: {} path: {} aclspec: {}", new Object[]{this.client.getFileSystem(), path.toString(), AclEntry.aclSpecToString(aclSpec)});
            this.identityTransformer.transformAclEntriesForSetRequest(aclSpec);
            Map<String, String> aclEntries = AbfsAclHelper.deserializeAclSpec(AclEntry.aclSpecToString(aclSpec));
            boolean isUpnFormat = AbfsAclHelper.isUpnFormatAclEntries(aclEntries);
            AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true), isUpnFormat);
            perfInfoGet.registerResult(op.getResult());
            String eTag = op.getResult().getResponseHeader("ETag");
            Map<String, String> getAclEntries = AbfsAclHelper.deserializeAclSpec(op.getResult().getResponseHeader("x-ms-acl"));
            AbfsAclHelper.setAclEntriesInternal(aclEntries, getAclEntries);
            perfInfoGet.registerSuccess(true).finishTracking();
            try (AbfsPerfInfo perfInfoSet = this.startTracking("setAcl", "setAcl");){
                AbfsRestOperation setAclOp = this.client.setAcl("/" + this.getRelativePath(path, true), AbfsAclHelper.serializeAclSpec(aclEntries), eTag);
                perfInfoSet.registerResult(setAclOp.getResult()).registerSuccess(true).registerAggregates(perfInfoGet.getTrackingStart(), 2L);
            }
        }
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        if (!this.getIsNamespaceEnabled()) {
            throw new UnsupportedOperationException("This operation is only valid for storage accounts with the hierarchical namespace enabled.");
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("getAclStatus", "getAclStatus");){
            LOG.debug("getAclStatus filesystem: {} path: {}", (Object)this.client.getFileSystem(), (Object)path.toString());
            AbfsRestOperation op = this.client.getAclStatus("/" + this.getRelativePath(path, true));
            AbfsHttpOperation result = op.getResult();
            perfInfo.registerResult(result);
            String transformedOwner = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-owner"), true, this.userName);
            String transformedGroup = this.identityTransformer.transformIdentityForGetRequest(result.getResponseHeader("x-ms-group"), false, this.primaryUserGroup);
            String permissions = result.getResponseHeader("x-ms-permissions");
            String aclSpecString = op.getResult().getResponseHeader("x-ms-acl");
            List<AclEntry> aclEntries = AclEntry.parseAclSpec(AbfsAclHelper.processAclString(aclSpecString), true);
            this.identityTransformer.transformAclEntriesForGetRequest(aclEntries, this.userName, this.primaryUserGroup);
            AbfsPermission fsPermission = permissions == null ? new AbfsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL) : AbfsPermission.valueOf(permissions);
            AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
            aclStatusBuilder.owner(transformedOwner);
            aclStatusBuilder.group(transformedGroup);
            aclStatusBuilder.setPermission(fsPermission);
            aclStatusBuilder.stickyBit(fsPermission.getStickyBit());
            aclStatusBuilder.addEntries(aclEntries);
            perfInfo.registerSuccess(true);
            AclStatus aclStatus = aclStatusBuilder.build();
            return aclStatus;
        }
    }

    public void access(Path path, FsAction mode) throws AzureBlobFileSystemException {
        LOG.debug("access for filesystem: {}, path: {}, mode: {}", new Object[]{this.client.getFileSystem(), path, mode});
        if (!this.abfsConfiguration.isCheckAccessEnabled() || !this.getIsNamespaceEnabled()) {
            LOG.debug("Returning; either check access is not enabled or the account used is not namespace enabled");
            return;
        }
        try (AbfsPerfInfo perfInfo = this.startTracking("access", "checkAccess");){
            String relativePath = "/" + this.getRelativePath(path, true);
            AbfsRestOperation op = this.client.checkAccess(relativePath, mode.SYMBOL);
            perfInfo.registerResult(op.getResult()).registerSuccess(true);
        }
    }

    public boolean isAtomicRenameKey(String key) {
        return this.isKeyForDirectorySet(key, this.azureAtomicRenameDirSet);
    }

    private void initializeClient(URI uri, String fileSystemName, String accountName, boolean isSecure) throws AzureBlobFileSystemException {
        URL baseUrl;
        if (this.client != null) {
            return;
        }
        URIBuilder uriBuilder = this.getURIBuilder(accountName, isSecure);
        String url = uriBuilder.toString() + "/" + fileSystemName;
        try {
            baseUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new InvalidUriException(uri.toString());
        }
        SharedKeyCredentials creds = null;
        AccessTokenProvider tokenProvider = null;
        if (this.abfsConfiguration.getAuthType(accountName) == AuthType.SharedKey) {
            LOG.trace("Fetching SharedKey credentials");
            int dotIndex = accountName.indexOf(".");
            if (dotIndex <= 0) {
                throw new InvalidUriException(uri.toString() + " - account name is not fully qualified.");
            }
            creds = new SharedKeyCredentials(accountName.substring(0, dotIndex), this.abfsConfiguration.getStorageAccountKey());
        } else {
            LOG.trace("Fetching token provider");
            tokenProvider = this.abfsConfiguration.getTokenProvider();
        }
        LOG.trace("Initializing AbfsClient for {}", (Object)baseUrl);
        this.client = new AbfsClient(baseUrl, creds, this.abfsConfiguration, new ExponentialRetryPolicy(this.abfsConfiguration.getMaxIoRetries()), tokenProvider, this.abfsPerfTracker);
        LOG.trace("AbfsClient init complete");
    }

    private String getOctalNotation(FsPermission fsPermission) {
        Preconditions.checkNotNull(fsPermission, "fsPermission");
        return String.format("%04d", fsPermission.toOctal());
    }

    private String getRelativePath(Path path) {
        return this.getRelativePath(path, false);
    }

    private String getRelativePath(Path path, boolean allowRootPath) {
        Preconditions.checkNotNull(path, "path");
        String relativePath = path.toUri().getPath();
        if (relativePath.length() == 0 || relativePath.length() == 1 && relativePath.charAt(0) == '/') {
            return allowRootPath ? "/" : "";
        }
        if (relativePath.charAt(0) == '/') {
            return relativePath.substring(1);
        }
        return relativePath;
    }

    private long parseContentLength(String contentLength) {
        if (contentLength == null) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    private boolean parseIsDirectory(String resourceType) {
        return resourceType != null && resourceType.equalsIgnoreCase("directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long parseLastModifiedTime(String lastModifiedTime) {
        long parsedTime = 0L;
        try {
            Date utcDate = new SimpleDateFormat(DATE_TIME_PATTERN, Locale.US).parse(lastModifiedTime);
            parsedTime = utcDate.getTime();
            return parsedTime;
        }
        catch (ParseException e) {
            LOG.error("Failed to parse the date {}", (Object)lastModifiedTime);
        }
        finally {
            return parsedTime;
        }
    }

    private String convertXmsPropertiesToCommaSeparatedString(Hashtable<String, String> properties) throws CharacterCodingException {
        StringBuilder commaSeparatedProperties = new StringBuilder();
        CharsetEncoder encoder = Charset.forName(XMS_PROPERTIES_ENCODING).newEncoder();
        for (Map.Entry<String, String> propertyEntry : properties.entrySet()) {
            String key = propertyEntry.getKey();
            String value = propertyEntry.getValue();
            Boolean canEncodeValue = encoder.canEncode(value);
            if (!canEncodeValue.booleanValue()) {
                throw new CharacterCodingException();
            }
            String encodedPropertyValue = Base64.encode(encoder.encode(CharBuffer.wrap(value)).array());
            commaSeparatedProperties.append(key).append("=").append(encodedPropertyValue);
            commaSeparatedProperties.append(",");
        }
        if (commaSeparatedProperties.length() != 0) {
            commaSeparatedProperties.deleteCharAt(commaSeparatedProperties.length() - 1);
        }
        return commaSeparatedProperties.toString();
    }

    private Hashtable<String, String> parseCommaSeparatedXmsProperties(String xMsProperties) throws InvalidFileSystemPropertyException, InvalidAbfsRestOperationException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        CharsetDecoder decoder = Charset.forName(XMS_PROPERTIES_ENCODING).newDecoder();
        if (xMsProperties != null && !xMsProperties.isEmpty()) {
            String[] userProperties = xMsProperties.split(",");
            if (userProperties.length == 0) {
                return properties;
            }
            for (String property : userProperties) {
                String value;
                if (property.isEmpty()) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                String[] nameValue = property.split("=", 2);
                if (nameValue.length != 2) {
                    throw new InvalidFileSystemPropertyException(xMsProperties);
                }
                byte[] decodedValue = Base64.decode(nameValue[1]);
                try {
                    value = decoder.decode(ByteBuffer.wrap(decodedValue)).toString();
                }
                catch (CharacterCodingException ex) {
                    throw new InvalidAbfsRestOperationException(ex);
                }
                properties.put(nameValue[0], value);
            }
        }
        return properties;
    }

    private boolean isKeyForDirectorySet(String key, Set<String> dirSet) {
        for (String dir : dirSet) {
            if (dir.isEmpty() || key.startsWith(dir + "/")) {
                return true;
            }
            try {
                URI uri = new URI(dir);
                if (null != uri.getAuthority() || !key.startsWith(dir + "/")) continue;
                return true;
            }
            catch (URISyntaxException e) {
                LOG.info("URI syntax error creating URI for {}", (Object)dir);
            }
        }
        return false;
    }

    private AbfsPerfInfo startTracking(String callerName, String calleeName) {
        return new AbfsPerfInfo(this.abfsPerfTracker, callerName, calleeName);
    }

    @VisibleForTesting
    AbfsClient getClient() {
        return this.client;
    }

    private static class VersionedFileStatus
    extends FileStatus {
        private final String version;

        VersionedFileStatus(String owner, String group, FsPermission fsPermission, boolean hasAcl, long length, boolean isdir, int blockReplication, long blocksize, long modificationTime, Path path, String version) {
            super(length, isdir, blockReplication, blocksize, modificationTime, 0L, fsPermission, owner, group, null, path, hasAcl, false, false);
            this.version = version;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FileStatus)) {
                return false;
            }
            FileStatus other = (FileStatus)obj;
            if (!this.getPath().equals(other.getPath())) {
                return false;
            }
            if (other instanceof VersionedFileStatus) {
                return this.version.equals(((VersionedFileStatus)other).version);
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = this.getPath().hashCode();
            hash = 89 * hash + (this.version != null ? this.version.hashCode() : 0);
            return hash;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("VersionedFileStatus{");
            sb.append(super.toString());
            sb.append("; version='").append(this.version).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

