/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage;

import java.io.IOException;
import java.net.SocketException;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.OperationContext;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageErrorCode;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.StorageExtendedErrorInformation;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.StorageRequest;
import org.apache.flink.fs.azure.shaded.com.microsoft.azure.storage.core.Utility;

public class StorageException
extends Exception {
    private static final long serialVersionUID = 7972747254288274928L;
    protected String errorCode;
    protected StorageExtendedErrorInformation extendedErrorInformation;
    private final int httpStatusCode;

    public static StorageException translateClientException(Exception cause) {
        return new StorageException("Client error", "A Client side exception occurred, please check the inner exception for details", 306, null, cause);
    }

    public static StorageException translateException(StorageRequest<?, ?, ?> request, Exception cause, OperationContext opContext) {
        if (request == null || request.getConnection() == null) {
            return StorageException.translateClientException(cause);
        }
        if (cause instanceof SocketException) {
            String message = cause == null ? "" : cause.getMessage();
            return new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), "An unknown failure occurred : ".concat(message), 500, null, cause);
        }
        StorageException translatedException = null;
        String responseMessage = null;
        int responseCode = 0;
        try {
            responseCode = request.getConnection().getResponseCode();
            responseMessage = request.getConnection().getResponseMessage();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (responseMessage == null) {
            responseMessage = "";
        }
        StorageExtendedErrorInformation extendedError = request.parseErrorDetails();
        translatedException = new StorageException(request.getResult().getErrorCode(), responseMessage, responseCode, extendedError, cause);
        Utility.logHttpError(translatedException, opContext);
        return translatedException;
    }

    public StorageException(String errorCode, String message, Exception innerException) {
        this(errorCode, message, 306, null, innerException);
    }

    public StorageException(String errorCode, String message, int statusCode, StorageExtendedErrorInformation extendedErrorInfo, Exception innerException) {
        super(message, innerException);
        this.errorCode = errorCode;
        this.httpStatusCode = statusCode;
        this.extendedErrorInformation = extendedErrorInfo;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public StorageExtendedErrorInformation getExtendedErrorInformation() {
        return this.extendedErrorInformation;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

