/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.utils.python;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sources.InputFormatTableSource;
import org.apache.flink.types.Row;

import java.util.List;

/** An {@link InputFormatTableSource} created by python 'from_element' method. */
@Internal
public class PythonInputFormatTableSource extends InputFormatTableSource<Row> {

    /**
     * The input format which contains the python data collection, usually created by {@link
     * PythonTableUtils#getInputFormat(List, TypeInformation, ExecutionConfig)} method.
     */
    private final InputFormat<Row, ? extends InputSplit> inputFormat;

    /**
     * The row type info of the python data. It is generated by the python 'from_element' method.
     */
    private final RowTypeInfo rowTypeInfo;

    public PythonInputFormatTableSource(
            InputFormat<Row, ? extends InputSplit> inputFormat, RowTypeInfo rowTypeInfo) {
        this.inputFormat = inputFormat;
        this.rowTypeInfo = rowTypeInfo;
    }

    @Override
    public InputFormat<Row, ?> getInputFormat() {
        return inputFormat;
    }

    @Override
    public TableSchema getTableSchema() {
        return TableSchema.fromTypeInfo(rowTypeInfo);
    }

    @Override
    public TypeInformation<Row> getReturnType() {
        return rowTypeInfo;
    }
}
