/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.api.connector.sink2.TwoPhaseCommittingSink;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.writer.FileWriterBucket;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketFactory;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketState;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FileWriter<IN>
implements StatefulSink.StatefulSinkWriter<IN, FileWriterBucketState>,
TwoPhaseCommittingSink.PrecommittingSinkWriter<IN, FileSinkCommittable>,
SinkWriter<IN>,
ProcessingTimeService.ProcessingTimeCallback {
    private static final Logger LOG = LoggerFactory.getLogger(FileWriter.class);
    private final Path basePath;
    private final FileWriterBucketFactory<IN> bucketFactory;
    private final BucketAssigner<IN, String> bucketAssigner;
    private final BucketWriter<IN, String> bucketWriter;
    private final RollingPolicy<IN, String> rollingPolicy;
    private final ProcessingTimeService processingTimeService;
    private final long bucketCheckInterval;
    private final BucketerContext bucketerContext;
    private final Map<String, FileWriterBucket<IN>> activeBuckets;
    private final OutputFileConfig outputFileConfig;
    private final Counter numRecordsSendCounter;
    private boolean endOfInput;

    public FileWriter(Path basePath, SinkWriterMetricGroup metricGroup, BucketAssigner<IN, String> bucketAssigner, FileWriterBucketFactory<IN> bucketFactory, BucketWriter<IN, String> bucketWriter, RollingPolicy<IN, String> rollingPolicy, OutputFileConfig outputFileConfig, ProcessingTimeService processingTimeService, long bucketCheckInterval) {
        this.basePath = (Path)Preconditions.checkNotNull((Object)basePath);
        this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(bucketAssigner);
        this.bucketFactory = (FileWriterBucketFactory)Preconditions.checkNotNull(bucketFactory);
        this.bucketWriter = (BucketWriter)Preconditions.checkNotNull(bucketWriter);
        this.rollingPolicy = (RollingPolicy)Preconditions.checkNotNull(rollingPolicy);
        this.outputFileConfig = (OutputFileConfig)Preconditions.checkNotNull((Object)outputFileConfig);
        this.activeBuckets = new HashMap<String, FileWriterBucket<IN>>();
        this.bucketerContext = new BucketerContext();
        this.numRecordsSendCounter = ((SinkWriterMetricGroup)Preconditions.checkNotNull((Object)metricGroup)).getNumRecordsSendCounter();
        this.processingTimeService = (ProcessingTimeService)Preconditions.checkNotNull((Object)processingTimeService);
        Preconditions.checkArgument((bucketCheckInterval > 0L ? 1 : 0) != 0, (Object)"Bucket checking interval for processing time should be positive.");
        this.bucketCheckInterval = bucketCheckInterval;
    }

    public void initializeState(Collection<FileWriterBucketState> bucketStates) throws IOException {
        Preconditions.checkNotNull(bucketStates, (String)"The retrieved state was null.");
        for (FileWriterBucketState state : bucketStates) {
            String bucketId = state.getBucketId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Restoring: {}", (Object)state);
            }
            FileWriterBucket<IN> restoredBucket = this.bucketFactory.restoreBucket(this.bucketWriter, this.rollingPolicy, state, this.outputFileConfig);
            this.updateActiveBucketId(bucketId, restoredBucket);
        }
        this.registerNextBucketInspectionTimer();
    }

    private void updateActiveBucketId(String bucketId, FileWriterBucket<IN> restoredBucket) throws IOException {
        FileWriterBucket<IN> bucket = this.activeBuckets.get(bucketId);
        if (bucket != null) {
            bucket.merge(restoredBucket);
        } else {
            this.activeBuckets.put(bucketId, restoredBucket);
        }
    }

    public void write(IN element, SinkWriter.Context context) throws IOException, InterruptedException {
        this.bucketerContext.update(context.timestamp(), context.currentWatermark(), this.processingTimeService.getCurrentProcessingTime());
        String bucketId = (String)this.bucketAssigner.getBucketId(element, (BucketAssigner.Context)this.bucketerContext);
        FileWriterBucket<IN> bucket = this.getOrCreateBucketForBucketId(bucketId);
        bucket.write(element, this.processingTimeService.getCurrentProcessingTime());
        this.numRecordsSendCounter.inc();
    }

    public void flush(boolean endOfInput) throws IOException, InterruptedException {
        this.endOfInput = endOfInput;
    }

    public Collection<FileSinkCommittable> prepareCommit() throws IOException {
        ArrayList<FileSinkCommittable> committables = new ArrayList<FileSinkCommittable>();
        Iterator<Map.Entry<String, FileWriterBucket<IN>>> activeBucketIt = this.activeBuckets.entrySet().iterator();
        while (activeBucketIt.hasNext()) {
            Map.Entry<String, FileWriterBucket<IN>> entry = activeBucketIt.next();
            if (!entry.getValue().isActive()) {
                activeBucketIt.remove();
                continue;
            }
            committables.addAll(entry.getValue().prepareCommit(this.endOfInput));
        }
        return committables;
    }

    public List<FileWriterBucketState> snapshotState(long checkpointId) throws IOException {
        Preconditions.checkState((this.bucketWriter != null ? 1 : 0) != 0, (Object)"sink has not been initialized");
        ArrayList<FileWriterBucketState> state = new ArrayList<FileWriterBucketState>();
        for (FileWriterBucket<IN> bucket : this.activeBuckets.values()) {
            state.add(bucket.snapshotState());
        }
        return state;
    }

    private FileWriterBucket<IN> getOrCreateBucketForBucketId(String bucketId) throws IOException {
        FileWriterBucket<IN> bucket = this.activeBuckets.get(bucketId);
        if (bucket == null) {
            Path bucketPath = this.assembleBucketPath(bucketId);
            bucket = this.bucketFactory.getNewBucket(bucketId, bucketPath, this.bucketWriter, this.rollingPolicy, this.outputFileConfig);
            this.activeBuckets.put(bucketId, bucket);
        }
        return bucket;
    }

    public void close() {
        if (this.activeBuckets != null) {
            this.activeBuckets.values().forEach(FileWriterBucket::disposePartFile);
        }
    }

    private Path assembleBucketPath(String bucketId) {
        if ("".equals(bucketId)) {
            return this.basePath;
        }
        return new Path(this.basePath, bucketId);
    }

    public void onProcessingTime(long time) throws IOException {
        for (FileWriterBucket<IN> bucket : this.activeBuckets.values()) {
            bucket.onProcessingTime(time);
        }
        this.registerNextBucketInspectionTimer();
    }

    private void registerNextBucketInspectionTimer() {
        long nextInspectionTime = this.processingTimeService.getCurrentProcessingTime() + this.bucketCheckInterval;
        this.processingTimeService.registerTimer(nextInspectionTime, (ProcessingTimeService.ProcessingTimeCallback)this);
    }

    @VisibleForTesting
    Map<String, FileWriterBucket<IN>> getActiveBuckets() {
        return this.activeBuckets;
    }

    private static final class BucketerContext
    implements BucketAssigner.Context {
        @Nullable
        private Long elementTimestamp = null;
        private long currentWatermark = Long.MIN_VALUE;
        private long currentProcessingTime = Long.MIN_VALUE;

        private BucketerContext() {
        }

        void update(@Nullable Long elementTimestamp, long watermark, long currentProcessingTime) {
            this.elementTimestamp = elementTimestamp;
            this.currentWatermark = watermark;
            this.currentProcessingTime = currentProcessingTime;
        }

        public long currentProcessingTime() {
            return this.currentProcessingTime;
        }

        public long currentWatermark() {
            return this.currentWatermark;
        }

        @Nullable
        public Long timestamp() {
            return this.elementTimestamp;
        }
    }
}

